/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.common.utils.CdArrayUtils;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.scalar.OlapDoubleVectorEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.mdx.numeric.OlapBaseGenericStatisticalFunction;
import crazydev.iccube.olap.eval.function.mdx.numeric.calculators.OlapSetCalculatorOneGenExpression;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import java.io.Serializable;
import java.util.Objects;

public class OlapVectorKFunction
extends OlapBaseGenericStatisticalFunction {
    public static final String NAME = "VectorK";

    public OlapVectorKFunction() {
        super(NAME);
    }

    protected OlapSetCalculatorOneGenExpression createCalculator(final GFFunctionArgs args, OlapTupleSet set) {
        return new OlapSetCalculatorOneGenExpression(){
            DoubleArrayList arrayList;
            final /* synthetic */ OlapVectorKFunction this$0;
            {
                OlapVectorKFunction olapVectorKFunction = this$0;
                Objects.requireNonNull(olapVectorKFunction);
                this.this$0 = olapVectorKFunction;
                this.arrayList = new DoubleArrayList();
            }

            public boolean isResultEmpty() {
                return this.arrayList.isEmpty();
            }

            public OlapEntity calculate() {
                return new OlapDoubleVectorEntity(this.arrayList.elements());
            }

            public int stopIterationOrdinal() {
                return -1;
            }

            public void addNull(OlapTuple setTuple, int iTupleOrdinal) {
            }

            public void addValue(GFContext context, OlapTuple setTuple, int iTupleOrdinal, OlapScalarEntity value) {
                if (setTuple.getMemberCount() != 1) {
                    this.this$0.onFunctionArgTypeMismatchError(args.getErrorContext(context), 0, "member", setTuple.getFriendlyTypeName());
                    return;
                }
                if (!(value instanceof OlapNumericEntity)) {
                    this.this$0.onFunctionArgTypeMismatchError(args.getErrorContext(context), 1, "numeric", value.getFriendlyTypeName());
                    return;
                }
                double valueAsDouble = ((OlapNumericEntity)value).doubleValue();
                Comparable keyValue = setTuple.getMember(0).getKeyValue();
                if (!(keyValue instanceof Integer)) {
                    this.this$0.onFunctionArgTypeMismatchError(args.getErrorContext(context), 0, "Integer", "all set member key needs to be an integer type, got " + keyValue.getClass().getSimpleName());
                    return;
                }
                int keyAsInt = (Integer)keyValue;
                if (keyAsInt < 0) {
                    this.this$0.onFunctionArgTypeMismatchError(args.getErrorContext(context), 0, "Positive Integer", "all set member key needs to be a 'positive' integer type, got " + keyAsInt);
                    return;
                }
                try {
                    int newSize = keyAsInt + 1;
                    CdArrayUtils.resize((DoubleArrayList)this.arrayList, (int)newSize);
                    this.arrayList.set(keyAsInt, valueAsDouble + this.arrayList.getDouble(keyAsInt));
                }
                catch (OutOfMemoryError error) {
                    this.arrayList.clear();
                    this.this$0.onFunctionError(args.getErrorContext(context), OlapErrorCode.VECTOR_ERROR, new Serializable[]{"Out of memory allocating a vector of size " + keyAsInt + " (hint : member keys not compacted {0,1,2,....n,n+1} ? )"});
                }
            }
        };
    }
}

