/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.impl.IGFStrToFunctionCallback;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.mdx.member.OlapMdxNavigationFunction;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import java.util.Objects;

public class OlapValidateMemberFunction
extends OlapMdxNavigationFunction {
    public static final String NAME = "ValidateMember";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(1, 2){

        public OlapFunctionArgumentType getType(int pos) {
            return OlapFunctionArgumentType.VALUE;
        }
    };

    public OlapValidateMemberFunction() {
        super(NAME, ARGS);
    }

    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        try {
            return this.unsafeEvalForCluster(context, args);
        }
        catch (Exception ex) {
            OlapLoggers.MDX_EVALUATION.info((Object)"[mdx] validateMember : exception", (Throwable)ex);
            return this.marker(context);
        }
    }

    private OlapNonScalarEntity unsafeEvalForCluster(final GFContext context, GFFunctionArgs args) {
        int count = args.getArgLength();
        if (count == 1) {
            String expr = args.toMdxStringExpression(context, 0);
            if (expr.trim().isEmpty()) {
                OlapLoggers.MDX_EVALUATION.info((Object)"[mdx] validateMember : empty expression");
                return this.marker(context);
            }
            OlapLoggers.MDX_EVALUATION.info((Object)("[mdx] validateMember : validating [" + expr + "]"));
            return (OlapNonScalarEntity)args.executeStrToMdxExpression(context, true, (OlapFunction)this, 0, expr, "validate-member-?", (IGFStrToFunctionCallback)new IGFStrToFunctionCallback<OlapNonScalarEntity>(this){
                final /* synthetic */ OlapValidateMemberFunction this$0;
                {
                    OlapValidateMemberFunction olapValidateMemberFunction = this$0;
                    Objects.requireNonNull(olapValidateMemberFunction);
                    this.this$0 = olapValidateMemberFunction;
                }

                public OlapNonScalarEntity onEntityNull() {
                    OlapLoggers.MDX_EVALUATION.info((Object)"[mdx] validateMember : null entity");
                    return this.this$0.marker(context);
                }

                public OlapNonScalarEntity onEntity(GFContext context1, GFTupleEvaluator evaluator, GFContext constrainedContext, OlapEntity entity1) {
                    if (entity1.isToMemberApplicable(context1.getPrepareContext())) {
                        OlapMember member = entity1.toNullableMember(constrainedContext.getPrepareContext());
                        if (member == null) {
                            OlapLoggers.MDX_EVALUATION.info((Object)("[mdx] validateMember : null member [" + entity1.getFriendlyTypeName() + "] [" + String.valueOf(entity1) + "]"));
                            return this.this$0.marker(context1);
                        }
                        return member;
                    }
                    OlapLoggers.MDX_EVALUATION.info((Object)("[mdx] validateMember : not a member [" + entity1.getFriendlyTypeName() + "] [" + String.valueOf(entity1) + "]"));
                    return this.this$0.marker(context1);
                }
            });
        }
        if (count == 2) {
            // empty if block
        }
        OlapLoggers.MDX_EVALUATION.info((Object)("[mdx] validateMember : unexpected arg. count [" + count + "]"));
        return this.marker(context);
    }

    private OlapMember marker(GFContext context) {
        OlapSchema schema = context.getSchema();
        return schema.getOrCreateValidateMemberMarker();
    }
}

