/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.scalar.OlapDoubleMatrixAEntity;
import crazydev.iccube.olap.entity.scalar.OlapDoubleMatrixEntity;
import crazydev.iccube.olap.entity.scalar.OlapDoubleVectorAEntity;
import crazydev.iccube.olap.entity.scalar.OlapDoubleVectorEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.set.OlapListTupleSet;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapScalarEntityFunction;
import java.io.Serializable;

public class OlapSetAxesFunction
extends OlapScalarEntityFunction {
    public static final String NAME = "SetAxes";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(2, 3){

        public OlapFunctionArgumentType getType(int pos) {
            switch (pos) {
                case 0: {
                    return OlapFunctionArgumentType.VALUE;
                }
            }
            return super.getType(pos);
        }
    };

    public OlapSetAxesFunction() {
        super(NAME, ARGS);
    }

    public OlapScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        OlapScalarEntity firstParam = args.toValueIfApplicable(context, 0, "matrix/vector");
        if (firstParam instanceof OlapDoubleMatrixEntity) {
            return this.fromMatrix(context, args, (OlapDoubleMatrixEntity)firstParam);
        }
        if (firstParam instanceof OlapDoubleVectorEntity) {
            if (args.size() != 2) {
                return (OlapScalarEntity)args.onFunctionArgSizeError(context);
            }
            return this.fromVector(context, args, (OlapDoubleVectorEntity)firstParam);
        }
        OlapEntity arg = args.getNonMissingArgEntity(context, 0, "matrix/vector");
        return (OlapScalarEntity)args.onFunctionArgTypeMismatchError(context, 0, "matrix/vector", arg.getFriendlyTypeName());
    }

    private OlapScalarEntity fromVector(GFContext context, GFFunctionArgs args, OlapDoubleVectorEntity vectorEntity) {
        OlapTupleSet rows = args.toSet(context, 1);
        OlapListTupleSet rowList = rows.asTupleList();
        if (rowList.size() != vectorEntity.length()) {
            return (OlapScalarEntity)args.onFunctionError(context, OlapErrorCode.VECTOR_ERROR, new Serializable[]{"Set size '" + rowList.size() + "' does not match Vector size '" + vectorEntity.length() + "'"});
        }
        return new OlapDoubleVectorAEntity(rowList, vectorEntity);
    }

    private OlapScalarEntity fromMatrix(GFContext context, GFFunctionArgs args, OlapDoubleMatrixEntity matrix) {
        boolean colsIdx = true;
        int rowsIdx = 2;
        OlapTupleSet cols = args.toSet(context, 1);
        OlapTupleSet rows = args.toSet(context, 2);
        OlapListTupleSet colList = cols.asTupleList();
        OlapListTupleSet rowList = rows.asTupleList();
        if (colList.size() != matrix.cols()) {
            return (OlapScalarEntity)args.onFunctionError(context, OlapErrorCode.MATRIX_ERROR, new Serializable[]{"First set - cols - size '" + colList.size() + "' does not match matrix column size '" + matrix.cols() + "'"});
        }
        if (rowList.size() != matrix.rows()) {
            return (OlapScalarEntity)args.onFunctionError(context, OlapErrorCode.MATRIX_ERROR, new Serializable[]{"Second set - rows - size '" + rowList.size() + "' does not match matrix row size '" + matrix.rows() + "'"});
        }
        return new OlapDoubleMatrixAEntity(colList, rowList, matrix);
    }
}

