/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehavior;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehaviorFactoryContext;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehaviorOperator;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.OlapFilterIterator;
import crazydev.iccube.collection.olapiterator.fastcj.OlapFastCrossjoinIterator;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.set.OlapIteratorTupleSet;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapNonScalarEntityFunction;
import crazydev.iccube.olap.eval.select.context.OlapFastCrossjoinContext;
import crazydev.iccube.olap.eval.select.context.OlapNonEmptyBehaviorException;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class OlapNonEmptyXFunction
extends OlapNonScalarEntityFunction {
    public static final String NAME = "NonEmptyX";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(2, 3){

        public OlapFunctionArgumentType getType(int pos) {
            if (pos == 2) {
                return OlapFunctionArgumentType.VALUE;
            }
            return super.getType(pos);
        }
    };

    public OlapNonEmptyXFunction() {
        this(NAME);
    }

    public OlapNonEmptyXFunction(String name) {
        super(name, ARGS);
    }

    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        OlapTupleSet set = args.toSet(context, 0);
        if (!(set instanceof OlapIteratorTupleSet)) {
            return (OlapNonScalarEntity)args.onFunctionArgTypeMismatchError(context, 0, "crossjoin", set.getFriendlyTypeName());
        }
        OlapIteratorTupleSet iteratorSet = (OlapIteratorTupleSet)set;
        iteratorSet.hackForNonEmptyX();
        OlapIterator tupleIterator = iteratorSet.getIterator(false);
        OlapFilterIterator filter = null;
        if (tupleIterator instanceof OlapFilterIterator) {
            filter = (OlapFilterIterator)tupleIterator;
            tupleIterator = filter.getUnderlyingIterator();
        }
        if (!(tupleIterator instanceof OlapFastCrossjoinIterator)) {
            return (OlapNonScalarEntity)args.onFunctionArgTypeMismatchError(context, 0, "crossjoin", set.getFriendlyTypeName());
        }
        OlapFastCrossjoinIterator fastCrossjoinIterator = (OlapFastCrossjoinIterator)tupleIterator;
        OlapTupleDimensionality dimensionality = fastCrossjoinIterator.getTupleDimensionality();
        OlapMember member = args.toMember(context, 1);
        if (!member.isMeasure() || member.isCalculated()) {
            return (OlapNonScalarEntity)args.onFunctionArgTypeMismatchError(context, 1, "measure", member.getFriendlyTypeName());
        }
        OlapNumericEntity limit = args.isMissingArg(2) ? null : args.toNumeric(context, 2);
        S_NonEmptyBehavior nonEmptyBehaviors = this.getNEB(context, dimensionality, (OlapTuple)member);
        if (nonEmptyBehaviors != null && nonEmptyBehaviors.hasAggregationWithRollupHierarchy(OlapLoggers.MDX_EVALUATION_FAST_CROSSJOIN, "[fast-crossjoin] non-empty-x : ")) {
            OlapLoggers.MDX_EVALUATION.info((Object)"[non-empty-x] aggregation w/ rollup hierarchy not supported");
            throw new OlapEvaluationException((IOlapEvaluationExceptionContext)context, OlapErrorCode.SELECT_EVAL_UNEXPECTED_ERROR, new Serializable[]{"non-empty-x : fast crossjoin not supported for aggregation w/ rollup hierarchy"});
        }
        OlapFastCrossjoinContext cjContext = new OlapFastCrossjoinContext(context.getStatementExecutionContext(), (IOlapEvaluationExceptionContext)context, nonEmptyBehaviors);
        OlapFastCrossjoinIterator crossjoin = fastCrossjoinIterator.fastCrossjoinForNonEmptyProcessing(cjContext);
        crossjoin.hackForNonEmptyX();
        if (crossjoin == null) {
            throw new OlapEvaluationException((IOlapEvaluationExceptionContext)context, OlapErrorCode.SELECT_EVAL_UNEXPECTED_ERROR, new Serializable[]{"non-empty-x : fast crossjoin not enabled"});
        }
        if (limit != null && !limit.isEmpty()) {
            int value = limit.intValue();
            crossjoin = crossjoin.head(value);
        }
        if (filter != null) {
            return OlapSetFactory.instance((OlapIterator)filter.withUnderlying((OlapIterator)crossjoin));
        }
        return OlapSetFactory.instance((OlapIterator)crossjoin).asTupleList();
    }

    private S_NonEmptyBehavior getNEB(GFContext context, @Nullable OlapTupleDimensionality dimensionality, OlapTuple tuple) {
        if (dimensionality == null) {
            OlapLoggers.MDX_EVALUATION_FAST_CROSSJOIN.info((Object)"[fast-crossjoin] non-empty-x : null dimensionality => reverting to non-empty-behavior = $one$");
            return S_NonEmptyBehavior.one();
        }
        try {
            S_NonEmptyBehaviorFactoryContext nonEmptyBehaviorContext = context.createNonEmptyBehaviorContext(dimensionality);
            S_NonEmptyBehavior nonEmptyBehaviors = S_NonEmptyBehaviorOperator.tuple((S_NonEmptyBehaviorFactoryContext)nonEmptyBehaviorContext, (OlapTuple)tuple);
            return nonEmptyBehaviors;
        }
        catch (OlapNonEmptyBehaviorException ex) {
            OlapLoggers.MDX_EVALUATION_FAST_CROSSJOIN.error((Object)"[fast-crossjoin] non-empty-x : non-empty-behavior error", (Throwable)ex);
            throw new OlapEvaluationException((IOlapEvaluationExceptionContext)context, OlapErrorCode.SELECT_EVAL_UNEXPECTED_ERROR, new Serializable[]{"non-empty-x error : " + ex.getMessage()});
        }
    }
}

