/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.common.math.CdMatrixFactory;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.scalar.OlapDoubleMatrixEntity;
import crazydev.iccube.olap.entity.scalar.OlapDoubleVectorEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapScalarEntityFunction;
import java.io.Serializable;

public class OlapMatrixNFunction
extends OlapScalarEntityFunction {
    public static final String NAME = "MatrixN";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(1, Integer.MAX_VALUE){

        public OlapFunctionArgumentType getType(int pos) {
            return OlapFunctionArgumentType.VALUE;
        }
    };

    public OlapMatrixNFunction() {
        super(NAME, ARGS);
    }

    public OlapScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        double[][] values = new double[args.size()][];
        if (args.size() == 0) {
            return OlapMatrixNFunction.asEmpty();
        }
        for (int col = 0; col < args.size(); ++col) {
            OlapDoubleVectorEntity vector = args.toVector(context, col);
            double[] value = vector.asValue();
            values[col] = value;
            if (col == 0 || values[0].length == value.length) continue;
            return (OlapScalarEntity)this.onFunctionError(args.getErrorContext(context), OlapErrorCode.FUNCTION_ARGUMENT_TYPE_MISMATCH, new Serializable[]{Integer.valueOf(col), "Vector(" + vector.length() + ")", "Vector(" + values[0].length + ")", ""});
        }
        if (values[0].length == 0) {
            return OlapMatrixNFunction.asEmpty();
        }
        return new OlapDoubleMatrixEntity(CdMatrixFactory.fromVectors((double[][])values));
    }
}

