/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.common.math.CdIMatrix;
import crazydev.common.math.CdMatrixFactory;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.scalar.OlapDoubleMatrixEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.set.OlapListTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.mdx.numeric.OlapBaseGenericMatrixFunction;
import java.util.Objects;

public class OlapMatrixFunction
extends OlapBaseGenericMatrixFunction {
    public static final String NAME = "Matrix";

    public OlapMatrixFunction() {
        super(NAME, ARGS);
    }

    public OlapBaseGenericMatrixFunction.OlapSetCalculatorExpression createCalculator() {
        return new OlapBaseGenericMatrixFunction.OlapSetCalculatorExpression(this){
            private GFFunctionArgs funArgs;
            int colSize;
            CdIMatrix values;
            int row;
            int col;
            {
                Objects.requireNonNull(this$0);
                this.row = 0;
                this.col = 0;
            }

            public void init(GFFunctionArgs funArgs, OlapListTupleSet<? extends OlapTuple> rowList, OlapListTupleSet<? extends OlapTuple> colList) {
                this.funArgs = funArgs;
                int rowSize = rowList.size();
                this.colSize = colList.size();
                this.values = CdMatrixFactory.create((int)rowSize, (int)this.colSize);
            }

            public void addValue(GFContext context, OlapScalarEntity value) {
                if (value instanceof OlapNumericEntity) {
                    OlapNumericEntity numeric = (OlapNumericEntity)value;
                    this.setValue(numeric.doubleValue());
                } else {
                    this.funArgs.onFunctionArgTypeMismatchError(context, 3, "numeric", value.getFriendlyTypeName());
                }
            }

            public void addNull() {
                this.setValue(0.0);
            }

            private void setValue(double value) {
                this.values.setValue(this.row, this.col, value);
                ++this.col;
                if (this.col >= this.colSize) {
                    this.col = 0;
                    ++this.row;
                }
            }

            public OlapEntity calculate() {
                return new OlapDoubleMatrixEntity(this.values);
            }
        };
    }
}

