/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.enums.OlapLevelType;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.mdx.member.OlapMdxNavigationFunction;
import crazydev.iccube.plugin.olapfunctions.others.OlapLookupDateFunction;
import java.util.ArrayList;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.ReadablePartial;

public class OlapLookupDateRangeFunction
extends OlapMdxNavigationFunction {
    public static final String NAME = "LookupDateRange";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(3);

    public OlapLookupDateRangeFunction() {
        super(NAME, ARGS);
    }

    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        OlapMember member;
        OlapLevel level = args.toLevel(context, 0);
        OlapLevelType levelType = OlapLookupDateFunction.checkLevelIsDate(context, args, level, this.getName());
        IOlapSchemaPermission schemaPermissions = args.getSchemaPermissionsWithoutPerspective(context);
        OlapMemberFilter memberFilter = schemaPermissions.getDimensionsPermissions(args.getCube(context)).getMemberFilter();
        OlapScalarEntity startValue = args.toValue(context, 1, "scalar");
        OlapScalarEntity endValue = args.toValue(context, 2, "scalar");
        LocalDate lookupStart = OlapLookupDateFunction.toLocalDate(context, args, startValue, this.getName());
        LocalDate lookupEnd = OlapLookupDateFunction.toLocalDate(context, args, endValue, this.getName());
        ArrayList<OlapMember> members = new ArrayList<OlapMember>();
        OlapIterator iter = level.getMembers(memberFilter).getIterator(false);
        iter.reset();
        while ((member = (OlapMember)iter.next()) != null) {
            LocalDate start;
            Comparable keyValue = member.getKeyValue();
            if (keyValue instanceof LocalDate) {
                start = (LocalDate)keyValue;
            } else {
                if (!(keyValue instanceof LocalDateTime)) continue;
                start = ((LocalDateTime)keyValue).toLocalDate();
            }
            LocalDate end = levelType.getNextDate(start.toLocalDateTime(LocalTime.MIDNIGHT)).toLocalDate();
            boolean notInRange = lookupStart != null && CdTimeUtils.isAfterOrEquals((LocalDate)lookupStart, (LocalDate)end) || lookupEnd != null && start.isAfter((ReadablePartial)lookupEnd);
            if (notInRange) continue;
            members.add(member);
        }
        return OlapSetFactory.instance(members);
    }
}

