/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.common.collection.CdActionStoppable;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapMemberKey;
import crazydev.iccube.olap.entity.option.OlapOption;
import crazydev.iccube.olap.entity.scalar.OlapArgArrayWrapperScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapListScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.mdx.member.OlapMdxNavigationFunction;
import crazydev.iccube.plugin.olapfunctions.others.OlapLookupByKeyFunction;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

public class OlapLookupByKeysFunction
extends OlapMdxNavigationFunction {
    public static final String NAME = "LookupByKeys";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(2, Integer.MAX_VALUE){

        public OlapFunctionArgumentType getType(int pos) {
            switch (pos) {
                default: 
            }
            return super.getType(pos);
        }
    };

    public OlapLookupByKeysFunction() {
        super(NAME, ARGS);
    }

    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        boolean withStrNumbers;
        OlapHierarchy hierarchy;
        OlapEntity arg0 = args.getNonMissingArgEntity(context, 0, "hierarchy|dimension|level");
        OlapLevel level = null;
        if (arg0 instanceof OlapDimension) {
            hierarchy = args.toOnlyHierarchy(context, 0, (OlapDimension)arg0);
        } else if (arg0 instanceof OlapHierarchy) {
            hierarchy = (OlapHierarchy)arg0;
        } else if (arg0 instanceof OlapLevel) {
            level = (OlapLevel)arg0;
            hierarchy = level.getHierarchy();
        } else {
            return (OlapNonScalarEntity)args.onFunctionArgTypeMismatchError(context, 0, "hierarchy|dimension|level", arg0.getFriendlyTypeName());
        }
        boolean bl = withStrNumbers = args.toOptionalOptionX(context, 1, new OlapOption[]{OlapOption.STR_NUMBERS}) != null;
        if (withStrNumbers) {
            String str = args.toString(context, 2);
            return this.evalForClusterWithStrNumbers(context, args, hierarchy, level, str);
        }
        OlapMemberKey[] key = new OlapMemberKey[args.size() - 1];
        for (int ii = 0; ii < key.length; ++ii) {
            OlapScalarEntity scalar = args.asScalar(context, ii + 1);
            if (scalar instanceof OlapArgArrayWrapperScalarEntity) {
                OlapArgArrayWrapperScalarEntity wrapper = (OlapArgArrayWrapperScalarEntity)scalar;
                if (ii == 0) {
                    return this.evalForClusterWithArgArrayWrapper(context, args, hierarchy, level, wrapper.asValue());
                }
            }
            if (scalar instanceof OlapListScalarEntity) {
                OlapScalarEntity[] scalars = ((OlapListScalarEntity)scalar).asValue();
                key[ii] = OlapLookupByKeyFunction.createMultiKey(Arrays.asList(scalars), hierarchy.getDimension());
                continue;
            }
            key[ii] = OlapLookupByKeyFunction.createSingleKey(scalar, hierarchy.getDimension());
        }
        return OlapLookupByKeyFunction.lookupByKey(context, args, hierarchy, level, key, false, true);
    }

    private OlapNonScalarEntity evalForClusterWithArgArrayWrapper(GFContext context, GFFunctionArgs args, OlapHierarchy hierarchy, @Nullable OlapLevel level, OlapScalarEntity[] values) {
        OlapMemberKey[] key = new OlapMemberKey[values.length];
        for (int ii = 0; ii < values.length; ++ii) {
            OlapScalarEntity value = values[ii];
            key[ii] = OlapLookupByKeyFunction.createSingleKey(value, hierarchy.getDimension());
        }
        return OlapLookupByKeyFunction.lookupByKey(context, args, hierarchy, level, key, false, true);
    }

    private OlapNonScalarEntity evalForClusterWithStrNumbers(GFContext context, GFFunctionArgs args, OlapHierarchy hierarchy, OlapLevel level, String str) {
        ArrayList members = new ArrayList();
        OlapLookupByKeysFunction.forEachNumber(str, (CdActionStoppable<OlapScalarEntity>)((CdActionStoppable)scalar -> {
            OlapMemberKey key = OlapLookupByKeyFunction.createSingleKey(scalar, hierarchy.getDimension());
            OlapNonScalarEntity entity = OlapLookupByKeyFunction.lookupByKey(context, args, hierarchy, level, key, false);
            if (entity instanceof OlapMember) {
                OlapMember member = (OlapMember)entity;
                members.add(member);
            }
            return true;
        }));
        return OlapSetFactory.instance(members);
    }

    private static void forEachNumber(String str, CdActionStoppable<OlapScalarEntity> action) {
        long val;
        int end;
        int start = 0;
        while ((end = str.indexOf(",", start)) != -1) {
            if (end > start && !action.apply((Object)new OlapNumericEntity(val = Long.parseLong(str, start, end, 10)))) {
                return;
            }
            start = end + 1;
        }
        if (start < str.length()) {
            val = Long.parseLong(str, start, str.length(), 10);
            action.apply((Object)new OlapNumericEntity(val));
        }
    }
}

