/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.common.lang.CdXmlaSchemaType;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapCalculatedMember;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapMemberKey;
import crazydev.iccube.olap.entity.option.OlapOption;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.mdx.member.OlapMdxNavigationFunction;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapLookupByKeyFunction
extends OlapMdxNavigationFunction {
    public static final String NAME = "LookupByKey";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(2, Integer.MAX_VALUE){

        public OlapFunctionArgumentType getType(int pos) {
            switch (pos) {
                default: 
            }
            return super.getType(pos);
        }
    };

    public OlapLookupByKeyFunction() {
        super(NAME, ARGS);
    }

    private static OlapMemberKey[] createKey(List<OlapScalarEntity> scalars, OlapDimension dimension) {
        if (scalars.size() == 1) {
            return new OlapMemberKey[]{OlapLookupByKeyFunction.createSingleKey(scalars.get(0), dimension)};
        }
        return new OlapMemberKey[]{OlapLookupByKeyFunction.createMultiKey(scalars, dimension)};
    }

    static OlapMemberKey createSingleKey(OlapScalarEntity scalar, OlapDimension dimension) {
        OlapBuilderInputType inputType = OlapBuilderInputType.findByXmlaType((CdXmlaSchemaType)scalar.getXmlaType(null));
        Comparable convertedKeyValue = dimension.adaptKeyValue((Comparable)scalar.asValue());
        return OlapMemberKey.create((OlapBuilderInputType)inputType, (Comparable)convertedKeyValue);
    }

    static OlapMemberKey createMultiKey(List<OlapScalarEntity> scalars, OlapDimension dimension) {
        OlapBuilderInputType[] inputTypes = new OlapBuilderInputType[scalars.size()];
        Comparable[] convertedKeyValues = new Comparable[scalars.size()];
        for (int idx = 0; idx < scalars.size(); ++idx) {
            OlapScalarEntity scalar = scalars.get(idx);
            OlapBuilderInputType inputType = OlapBuilderInputType.findByXmlaType((CdXmlaSchemaType)scalar.getXmlaType(null));
            Comparable convertedKeyValue = dimension.adaptKeyValue((Comparable)scalar.asValue());
            inputTypes[idx] = inputType;
            convertedKeyValues[idx] = convertedKeyValue;
        }
        return OlapMemberKey.create((OlapBuilderInputType[])inputTypes, (Comparable[])convertedKeyValues);
    }

    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        OlapHierarchy hierarchy;
        OlapEntity arg0 = args.getNonMissingArgEntity(context, 0, "hierarchy|dimension|level");
        boolean typed = args.size() > 2 && args.toOptionalOptionX(context, args.size() - 1, new OlapOption[]{OlapOption.TYPED}) == OlapOption.TYPED;
        boolean isSet = false;
        OlapLevel level = null;
        if (arg0 instanceof OlapDimension) {
            hierarchy = args.toOnlyHierarchy(context, 0, (OlapDimension)arg0);
        } else if (arg0 instanceof OlapHierarchy) {
            hierarchy = (OlapHierarchy)arg0;
        } else if (arg0 instanceof OlapLevel) {
            level = (OlapLevel)arg0;
            hierarchy = level.getHierarchy();
        } else {
            return (OlapNonScalarEntity)args.onFunctionArgTypeMismatchError(context, 0, "hierarchy|dimension|level", arg0.getFriendlyTypeName());
        }
        OlapMemberKey[] key = null;
        OlapEntity sec = args.getNonMissingArgEntity(context, 1, "member");
        if (sec instanceof OlapMeasureMember || sec instanceof OlapCalculatedMember) {
            OlapScalarEntity value = args.toValue(context, 1, "scalar");
            if (value.isMdxNull()) {
                return OlapLookupByKeyFunction.asNull();
            }
            key = OlapLookupByKeyFunction.createKey(List.of(value), hierarchy.getDimension());
        } else if (sec instanceof OlapMember) {
            key = new OlapMemberKey[]{((OlapMember)sec).getKey()};
        } else {
            OlapTupleSet toSet = args.toSetIfApplicable(context, 1);
            if (toSet != null) {
                OlapTuple tuple;
                ArrayList<OlapMemberKey> keys = new ArrayList<OlapMemberKey>();
                OlapIterator tuples = toSet.getIterator(false);
                tuples.reset();
                while ((tuple = (OlapTuple)tuples.next()) != null) {
                    if (tuple instanceof OlapMember) {
                        OlapMember member = (OlapMember)tuple;
                        keys.add(member.getKey());
                        continue;
                    }
                    return (OlapNonScalarEntity)args.onFunctionArgTypeMismatchError(context, 0, "member-set", arg0.getFriendlyTypeName());
                }
                key = keys.toArray(new OlapMemberKey[keys.size()]);
                isSet = true;
            }
        }
        if (key == null) {
            key = OlapLookupByKeyFunction.createKey(OlapLookupByKeyFunction.getKeys(context, args, typed), hierarchy.getDimension());
        }
        return OlapLookupByKeyFunction.lookupByKey(context, args, hierarchy, level, key, typed, isSet);
    }

    private static List<OlapScalarEntity> getKeys(GFContext context, GFFunctionArgs args, boolean typed) {
        ArrayList<OlapScalarEntity> keys = new ArrayList<OlapScalarEntity>();
        int size = args.size() - (typed ? 1 : 0);
        for (int idx = 1; idx < size; ++idx) {
            OlapScalarEntity key = args.asScalar(context, idx);
            keys.add(key);
        }
        return keys;
    }

    static OlapNonScalarEntity lookupByKey(GFContext context, GFFunctionArgs args, OlapHierarchy hierarchy, @Nullable OlapLevel level, OlapMemberKey[] key, boolean typed, boolean asSet) {
        if (!asSet) {
            return OlapLookupByKeyFunction.lookupByKey(context, args, hierarchy, level, key[0], typed);
        }
        ArrayList<OlapMember> members = new ArrayList<OlapMember>();
        for (int ii = 0; ii < key.length; ++ii) {
            OlapNonScalarEntity member = OlapLookupByKeyFunction.lookupByKey(context, args, hierarchy, level, key[ii], typed);
            if (!(member instanceof OlapMember)) continue;
            members.add((OlapMember)member);
        }
        return OlapSetFactory.instance(members);
    }

    static OlapNonScalarEntity lookupByKey(GFContext context, GFFunctionArgs args, OlapHierarchy hierarchy, @Nullable OlapLevel olapLevel, OlapMemberKey key, boolean typed) {
        OlapMember[] foundMember = new OlapMember[1];
        Object keyValue = key.asJavaNativeValue();
        IOlapSchemaPermission schemaPermissions = args.getSchemaPermissionsWithoutPerspective(context);
        OlapMemberFilter memberFilter = schemaPermissions.getDimensionsPermissions(args.getCube(context)).getMemberFilter();
        if (hierarchy.canIndexByRange()) {
            Object actualKeyValue = OlapLookupByKeyFunction.convertLevelForKey(hierarchy.getLastLevel(), keyValue, typed);
            if (actualKeyValue == null) {
                return OlapLookupByKeyFunction.asNull();
            }
            OlapMember[] members = hierarchy.lookupMemberByRange(olapLevel, actualKeyValue);
            if (members.length != 1) {
                return OlapLookupByKeyFunction.asNull();
            }
            foundMember[0] = OlapLookupByKeyFunction.getFilteredMember(members[0], memberFilter);
        } else {
            for (OlapLevel level : hierarchy.getLevels()) {
                Object actualKeyValue;
                if (!(olapLevel != null && olapLevel != level || level.isAll() || (actualKeyValue = OlapLookupByKeyFunction.convertLevelForKey(level, keyValue, typed)) == null)) {
                    level.forEachMatchingKeyValue(args.getErrorContext(context), actualKeyValue, olapMember -> {
                        if (memberFilter == null || memberFilter.isAccepting(olapMember)) {
                            foundMember[0] = olapMember;
                            return false;
                        }
                        return true;
                    });
                }
                if (foundMember[0] == null) continue;
                break;
            }
        }
        return OlapLookupByKeyFunction.asNullable((OlapNonScalarEntity)foundMember[0]);
    }

    @Nullable
    private static OlapMember getFilteredMember(OlapMember memberToFilter, OlapMemberFilter memberFilter) {
        OlapMember member = memberToFilter;
        if (member != null && memberFilter != null && !memberFilter.isAccepting(member) && (member = member.getPrevMember(memberFilter)) == null) {
            member = memberToFilter.getNextMember(memberFilter);
        }
        return member;
    }

    @Nullable
    private static Object convertLevelForKey(OlapLevel level, Object keyValue, boolean typed) {
        if (typed) {
            return keyValue;
        }
        OlapBuilderInputType[] keyType = level.getMemberKeyType();
        if (keyType == null) {
            return null;
        }
        try {
            if (keyValue.getClass().isArray()) {
                if (keyType.length != Array.getLength(keyValue)) {
                    return null;
                }
                Comparable[] values = new Comparable[keyType.length];
                for (int i = 0; i < keyType.length; ++i) {
                    OlapBuilderInputType type = keyType[i];
                    values[i] = type.getTypeConverter().toJavaNativeValue(NAME, Array.get(keyValue, i));
                }
                return values;
            }
            return keyType[0].getTypeConverter().toJavaNativeValue(NAME, keyValue);
        }
        catch (Exception ex) {
            return null;
        }
    }
}

