/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.common.mdx.CdMdxColorUtils;
import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.olap.compiler.OlapCompilationContext;
import crazydev.iccube.olap.eval.function.OlapFunctionCallInstr;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.literal.OlapLocalDateLiteralInstr;
import crazydev.iccube.olap.eval.literal.OlapLocalDateTimeLiteralInstr;
import crazydev.iccube.olap.eval.literal.OlapLongLiteralInstr;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.plugin.function.OlapPluginEvaluationException;
import crazydev.iccube.plugin.function.OlapPluginUserJavaFunction;
import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public abstract class OlapIcCubeFunctions
extends OlapPluginUserJavaFunction {
    public static final OlapIcCubeFunctions CONTAINS = new OlapIcCubeFunctions(2, new Class[]{String.class, String.class}){

        protected Object doEval(Object[] args) {
            String s0 = (String)args[0];
            String s1 = (String)args[1];
            return s0 == null || s1 == null ? false : s0.contains(s1);
        }
    };
    public static final OlapPluginUserJavaFunction ISNAN = new SingleArgDoubleFunction(){

        @Override
        protected Boolean evaluate(double d) {
            return Double.isNaN(d);
        }
    };
    public static final OlapPluginUserJavaFunction ISINFINITY = new SingleArgDoubleFunction(){

        @Override
        protected Boolean evaluate(double d) {
            return Double.isInfinite(d);
        }
    };
    public static final OlapPluginUserJavaFunction TODAY = new OlapPluginUserJavaFunction(0, 0, new Class[0]){

        protected Object doEval(Object[] args) {
            LocalDate ic3 = CdTimeUtils.redefinedToday();
            if (ic3 != null) {
                return ic3;
            }
            return LocalDate.now();
        }
    };
    public static final OlapPluginUserJavaFunction DATETIME = new OlapIcCubeFunctions(2, 6, new Class[]{Integer.class, Integer.class, Integer.class, Integer.class, Integer.class, Integer.class}){

        @Nullable
        public OlapInstr asInstr(OlapCompilationContext context, OlapInstrLocationRange location, OlapFunctionCallInstr.Notation mdxNotation, OlapInstr[] args) {
            try {
                OlapInstr minutes;
                OlapInstr hours;
                OlapInstr day;
                OlapInstr month;
                OlapInstr year;
                if (args.length == 6) {
                    year = args[0];
                    month = args[1];
                    day = args[2];
                    hours = args[3];
                    minutes = args[4];
                    OlapInstr seconds = args[5];
                    if (year instanceof OlapLongLiteralInstr && month instanceof OlapLongLiteralInstr && day instanceof OlapLongLiteralInstr && hours instanceof OlapLongLiteralInstr && (minutes == null || minutes instanceof OlapLongLiteralInstr) && (seconds == null || seconds instanceof OlapLongLiteralInstr)) {
                        return new OlapLocalDateTimeLiteralInstr(location, new LocalDateTime(this.asYear(year), this.asNumeric(month), this.asNumeric(day), this.asNumeric(hours), this.asNumeric(minutes), this.asNumeric(seconds)));
                    }
                }
                if (args.length == 5) {
                    year = args[0];
                    month = args[1];
                    day = args[2];
                    hours = args[3];
                    minutes = args[4];
                    if (year instanceof OlapLongLiteralInstr && month instanceof OlapLongLiteralInstr && day instanceof OlapLongLiteralInstr && hours instanceof OlapLongLiteralInstr && (minutes == null || minutes instanceof OlapLongLiteralInstr)) {
                        return new OlapLocalDateTimeLiteralInstr(location, new LocalDateTime(this.asYear(year), this.asNumeric(month), this.asNumeric(day), this.asNumeric(hours), this.asNumeric(minutes)));
                    }
                }
                if (args.length == 3) {
                    year = args[0];
                    month = args[1];
                    day = args[2];
                    if (year instanceof OlapLongLiteralInstr && month instanceof OlapLongLiteralInstr && (day == null || day instanceof OlapLongLiteralInstr)) {
                        return new OlapLocalDateLiteralInstr(location, new LocalDate(this.asYear(year), this.asNumeric(month), this.asNumeric(day)));
                    }
                }
            }
            catch (RuntimeException ignored) {
                OlapLoggers.MDX_EVALUATION.warn((Object)"[mdx] could not optimize DateTime()", (Throwable)ignored);
            }
            return super.asInstr(context, location, mdxNotation, args);
        }

        private int asYear(OlapInstr<?> value) {
            int year;
            return year + ((year = ((OlapLongLiteralInstr)value).getValue().intValue()) > 100 ? 0 : 2000);
        }

        private int asNumeric(@Nullable OlapInstr<?> value) {
            if (value == null) {
                return 0;
            }
            return ((OlapLongLiteralInstr)value).getValue().intValue();
        }

        protected Object doEval(Object[] args) throws OlapPluginEvaluationException {
            OlapIcCubeFunctions.checkNotNull(args);
            int year = (Integer)args[0];
            int month = (Integer)args[1];
            int day = args.length > 2 ? (Integer)args[2] : 0;
            year += year > 100 ? 0 : 2000;
            if (args.length <= 3) {
                return new LocalDate(year, month, day);
            }
            int hours = (Integer)args[3];
            int minutes = args.length > 4 ? (Integer)args[4] : 0;
            int seconds = args.length > 5 ? (Integer)args[5] : 0;
            return new LocalDateTime(year, month, day, hours, minutes, seconds);
        }
    };
    public static final OlapPluginUserJavaFunction ToHexColor = new OlapPluginUserJavaFunction(1, new Class[]{Integer.TYPE}){

        protected Object doEval(Object[] args) {
            int decimal = (Integer)args[0];
            return CdMdxColorUtils.hexValue((int)decimal);
        }
    };

    protected OlapIcCubeFunctions(int minArgs, Class ... parametersType) {
        super(minArgs, parametersType);
    }

    protected OlapIcCubeFunctions(int minArgs, int maxArgs, Class ... parametersType) {
        super(minArgs, maxArgs, parametersType);
    }

    protected OlapIcCubeFunctions(Class[] ... params) {
        super(params);
    }

    private static void checkNotNull(Object[] args) throws OlapPluginEvaluationException {
        for (int i = 0; i < args.length; ++i) {
            if (args[i] != null) continue;
            throw new OlapPluginEvaluationException(OlapPluginEvaluationException.Kind.VALUE_INVALID, "parameter " + (i + 1) + " can not be null");
        }
    }

    private static abstract class SingleArgDoubleFunction
    extends OlapIcCubeFunctions {
        protected SingleArgDoubleFunction() {
            super(1, Double.class);
        }

        protected Object doEval(Object[] args) {
            Double arg = (Double)args[0];
            return arg == null ? Boolean.valueOf(this.isNull()) : this.evaluate(arg);
        }

        protected abstract Object evaluate(double var1);

        public boolean isNull() {
            return false;
        }
    }
}

