/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapStringEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapScalarEntityFunction;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public class OlapDateToStringFunction
extends OlapScalarEntityFunction {
    public static final String NAME = "DateToString";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(2, 3){

        public OlapFunctionArgumentType getType(int pos) {
            switch (pos) {
                case 1: 
                case 2: {
                    return OlapFunctionArgumentType.VALUE;
                }
            }
            return super.getType(pos);
        }
    };

    public OlapDateToStringFunction() {
        super(NAME, ARGS);
    }

    public OlapScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        Date date;
        OlapScalarEntity entity = args.toValue(context, 0, "date");
        if (entity.isMdxNull()) {
            return entity;
        }
        Object entityAsValue = entity.asValue();
        if (entityAsValue instanceof Date) {
            date = (Date)entityAsValue;
        } else if (entityAsValue instanceof LocalDate) {
            date = ((LocalDate)entityAsValue).toDate();
        } else if (entityAsValue instanceof LocalDateTime) {
            date = ((LocalDateTime)entityAsValue).toDate();
        } else {
            return (OlapScalarEntity)args.onFunctionArgTypeMismatchError(context, 0, "date|datetime", entity.getFriendlyTypeName());
        }
        String pattern = args.toString(context, 1);
        Locale locale = args.toOptionalLocale(context, 2);
        SimpleDateFormat formatter = new SimpleDateFormat(pattern, locale);
        String dateAsString = formatter.format(date);
        return new OlapStringEntity(dateAsString);
    }
}

