/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapRegularTuple;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapScalarEntityFunction;
import org.jetbrains.annotations.Nullable;

public abstract class OlapBaseIndexOfFunction
extends OlapScalarEntityFunction {
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(2){

        public OlapFunctionArgumentType getType(int pos) {
            switch (pos) {
                default: 
            }
            return super.getType(pos);
        }
    };

    public OlapBaseIndexOfFunction(String name) {
        super(name, ARGS);
    }

    protected int doEvalForCluster(GFContext context, GFFunctionArgs args, boolean forIsIn) {
        OlapTupleSet tupleSet;
        OlapTupleSet memberSet;
        OlapEntity arg0 = args.getNonMissingArgEntity(context, 0, "member-set");
        if (arg0.isMdxNull()) {
            return -1;
        }
        if (forIsIn) {
            if (arg0 instanceof OlapDimension) {
                return this.doEvalForCluster(context, args, (OlapDimension)arg0);
            }
            if (arg0 instanceof OlapHierarchy) {
                return this.doEvalForCluster(context, args, (OlapHierarchy)arg0);
            }
            if (arg0 instanceof OlapLevel) {
                return this.doEvalForCluster(context, args, (OlapLevel)arg0);
            }
        }
        if ((memberSet = (tupleSet = args.toSet(context, 0)).asMemberSet()) == null) {
            return (Integer)args.onFunctionArgTypeMismatchError(context, 0, "member-set", "tuple-set");
        }
        OlapMember member = this.asMemberForCluster(context, args);
        if (member == null) {
            return -1;
        }
        return this.doEval((OlapTupleSet<OlapMember>)memberSet, member);
    }

    @Nullable
    private OlapMember asMemberForCluster(GFContext context, GFFunctionArgs args) {
        OlapRegularTuple tuple;
        OlapEntity arg1 = args.getNonMissingArgEntity(context, 1, "member");
        if (arg1 instanceof OlapMember) {
            return (OlapMember)arg1;
        }
        if (arg1 instanceof OlapRegularTuple && (tuple = (OlapRegularTuple)arg1).getMemberCount() == 1) {
            return tuple.getMember(0);
        }
        return null;
    }

    private int doEvalForCluster(GFContext context, GFFunctionArgs args, OlapDimension dimension) {
        OlapMember member = this.asMemberForCluster(context, args);
        if (member == null) {
            return -1;
        }
        return dimension.equals((Object)member.getDimension()) ? 1 : -1;
    }

    private int doEvalForCluster(GFContext context, GFFunctionArgs args, OlapHierarchy hierarchy) {
        OlapMember member = this.asMemberForCluster(context, args);
        if (member == null) {
            return -1;
        }
        return hierarchy.equals((Object)member.getHierarchy()) ? 1 : -1;
    }

    private int doEvalForCluster(GFContext context, GFFunctionArgs args, OlapLevel level) {
        OlapMember member = this.asMemberForCluster(context, args);
        if (member == null) {
            return -1;
        }
        return level.equals((Object)member.getLevel()) ? 1 : -1;
    }

    private int doEval(OlapTupleSet<OlapMember> memberSet, OlapMember requestedMember) {
        OlapMember member;
        boolean firstMemberChecked = false;
        OlapIterator members = memberSet.getIterator(false);
        members.reset();
        int i = 0;
        while ((member = (OlapMember)members.next()) != null) {
            if (!firstMemberChecked) {
                if (!member.getHierarchy().equals((Object)requestedMember.getHierarchy())) {
                    return -1;
                }
                firstMemberChecked = true;
            }
            if (requestedMember.equals((Object)member)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

