/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapScalarEntityFunction;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public abstract class OlapBaseDateFunction
extends OlapScalarEntityFunction {
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(2, 3){

        public OlapFunctionArgumentType getType(int pos) {
            switch (pos) {
                case 0: 
                case 1: {
                    return OlapFunctionArgumentType.VALUE;
                }
            }
            return super.getType(pos);
        }
    };

    public OlapBaseDateFunction(String name) {
        super(name, ARGS);
    }

    protected abstract OlapScalarEntity asScalarEntity(Date var1);

    public OlapScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        String dateString = args.toString(context, 0);
        if (dateString == null) {
            return OlapEmptyEntity.INSTANCE;
        }
        String pattern = args.toString(context, 1);
        Locale locale = args.toOptionalLocale(context, 2);
        SimpleDateFormat formatter = new SimpleDateFormat(pattern, locale);
        try {
            Date date = formatter.parse(dateString);
            return this.asScalarEntity(date);
        }
        catch (ParseException error) {
            return (OlapScalarEntity)args.onFunctionError(context, OlapErrorCode.DATE_PARSING_ERROR, new Serializable[]{dateString, error.getMessage()});
        }
    }
}

