/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.plugin.olapfunctions.excel;

import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.plugin.function.OlapPluginEvaluationException;
import crazydev.iccube.plugin.function.OlapPluginUserJavaFunction;
import org.jetbrains.annotations.Nullable;

public abstract class OlapVBExcelTextFunctions
extends OlapPluginUserJavaFunction {
    public static final OlapPluginUserJavaFunction LEN = new SingleArgTextFunction(){

        @Override
        protected Integer evaluate(String arg) {
            if (arg == null) {
                return null;
            }
            return arg.length();
        }
    };
    public static final OlapPluginUserJavaFunction LOWER = new SingleArgTextFunction(){

        @Override
        protected String evaluate(String arg) {
            if (arg == null) {
                return null;
            }
            return arg.toLowerCase();
        }
    };
    public static final OlapPluginUserJavaFunction LCASE = new SingleArgTextFunction(){

        @Override
        protected String evaluate(String arg) {
            if (arg == null) {
                return null;
            }
            return arg.toLowerCase();
        }
    };
    public static final OlapPluginUserJavaFunction UPPER = new SingleArgTextFunction(){

        @Override
        protected String evaluate(String arg) {
            if (arg == null) {
                return null;
            }
            return arg.toUpperCase();
        }
    };
    public static final OlapPluginUserJavaFunction UCASE = new SingleArgTextFunction(){

        @Override
        protected String evaluate(String arg) {
            if (arg == null) {
                return null;
            }
            return arg.toUpperCase();
        }
    };
    public static final OlapPluginUserJavaFunction TRIM = new SingleArgTextFunction(){

        @Override
        protected String evaluate(String arg) {
            if (arg == null) {
                return null;
            }
            return arg.trim();
        }
    };
    public static final OlapPluginUserJavaFunction MID = new OlapVBExcelTextFunctions(3, new Class[]{String.class, Integer.TYPE, Integer.TYPE}){

        protected Object doEval(Object[] args) throws OlapPluginEvaluationException {
            String text = (String)args[0];
            if (text == null) {
                return null;
            }
            Integer startCharNum = (Integer)args[1];
            Integer numChars = (Integer)args[2];
            int startIx = startCharNum - 1;
            if (startIx < 0) {
                throw new OlapPluginEvaluationException(OlapPluginEvaluationException.Kind.VALUE_INVALID);
            }
            if (numChars < 0) {
                throw new OlapPluginEvaluationException(OlapPluginEvaluationException.Kind.VALUE_INVALID);
            }
            int len = text.length();
            if (numChars < 0 || startIx > len) {
                throw new OlapPluginEvaluationException(OlapPluginEvaluationException.Kind.VALUE_INVALID);
            }
            int endIx = Math.min(startIx + numChars, len);
            String result = text.substring(startIx, endIx);
            return result;
        }
    };
    public static final OlapVBExcelTextFunctions LEFT = new LeftRight(true);
    public static final OlapVBExcelTextFunctions RIGHT = new LeftRight(false);
    public static final OlapVBExcelTextFunctions CONCATENATE = new OlapVBExcelTextFunctions(2, 100, new Class[]{String.class}){

        protected Object doEval(Object[] args) throws OlapPluginEvaluationException {
            StringBuffer sb = new StringBuffer();
            int iSize = args.length;
            for (int i = 0; i < iSize; ++i) {
                if (args[i] == null) continue;
                sb.append(args[i]);
            }
            return sb.toString();
        }
    };
    public static final OlapVBExcelTextFunctions EXACT = new OlapVBExcelTextFunctions(2, new Class[]{String.class, String.class}){

        protected Object doEval(Object[] args) throws OlapPluginEvaluationException {
            String s0 = (String)args[0];
            String s1 = (String)args[1];
            return s0.equals(s1);
        }
    };
    public static final OlapVBExcelTextFunctions REPLACE = new OlapVBExcelTextFunctions(3, new Class[]{String.class, String.class, String.class}){

        protected Object doEval(Object[] args) throws OlapPluginEvaluationException {
            String s0 = (String)args[0];
            String s1 = (String)args[1];
            String s2 = (String)args[2];
            return s0.replace(s1, s2);
        }
    };
    public static final OlapVBExcelTextFunctions INSTR = new OlapVBExcelTextFunctions(new Class[][]{{String.class, String.class}, {Integer.class, String.class, String.class}}){

        protected Object doEval(Object[] args) throws OlapPluginEvaluationException {
            if (args.length == 2) {
                String s0 = (String)args[0];
                if (s0 == null) {
                    return null;
                }
                String s1 = (String)args[1];
                s0 = s0.toLowerCase();
                if ((s1 = s1.toLowerCase()) == null) {
                    return s0.isEmpty() ? 0 : 1;
                }
                return 1 + s0.indexOf(s1);
            }
            if (args.length == 3) {
                int start = (Integer)args[0];
                String s0 = (String)args[1];
                if (s0 == null) {
                    return null;
                }
                String s1 = (String)args[2];
                s0 = s0.toLowerCase();
                if ((s1 = s1.toLowerCase()) == null) {
                    if (start <= s0.length()) {
                        return start;
                    }
                    return 0;
                }
                return 1 + s0.indexOf(s1, start - 1);
            }
            throw new CdShouldNotBeHereProgrammingException();
        }
    };

    protected OlapVBExcelTextFunctions(int minArgs, Class ... parametersType) {
        super(minArgs, parametersType);
    }

    protected OlapVBExcelTextFunctions(int minArgs, int maxArgs, Class ... parametersType) {
        super(minArgs, maxArgs, parametersType);
    }

    protected OlapVBExcelTextFunctions(Class[] ... params) {
        super(params);
    }

    private static final class LeftRight
    extends OlapVBExcelTextFunctions {
        private final boolean _isLeft;

        protected LeftRight(boolean isLeft) {
            super(2, String.class, Integer.TYPE);
            this._isLeft = isLeft;
        }

        protected Object doEval(Object[] args) throws OlapPluginEvaluationException {
            String arg = (String)args[0];
            if (arg == null) {
                return null;
            }
            Integer index = (Integer)args[1];
            String result = this._isLeft ? arg.substring(0, Math.min(arg.length(), index)) : arg.substring(Math.max(0, arg.length() - index));
            return result;
        }
    }

    private static abstract class SingleArgTextFunction
    extends OlapVBExcelTextFunctions {
        protected SingleArgTextFunction() {
            super(1, String.class);
        }

        protected Object doEval(Object[] args) throws OlapPluginEvaluationException {
            return this.evaluate((String)args[0]);
        }

        protected abstract Object evaluate(@Nullable String var1);
    }
}

