/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.plugin.olapfunctions.excel;

import crazydev.common.lang.MathX;
import crazydev.iccube.plugin.function.OlapPluginEvaluationException;
import crazydev.iccube.plugin.function.OlapPluginUserJavaFunction;

public class OlapVBExcelNumericalFunctions {
    static final double ZERO = 0.0;
    static final double TEN = 10.0;
    static final double LOG_10_TO_BASE_e = Math.log(10.0);
    public static final OlapPluginUserJavaFunction ABS = new OneArg(){

        @Override
        protected double evaluate(double d) {
            return Math.abs(d);
        }
    };
    public static final OlapPluginUserJavaFunction ACOS = new OneArg(){

        @Override
        protected double evaluate(double d) {
            return Math.acos(d);
        }
    };
    public static final OlapPluginUserJavaFunction ACOSH = new OneArg(){

        @Override
        protected double evaluate(double d) {
            return MathX.acosh((double)d);
        }
    };
    public static final OlapPluginUserJavaFunction ASIN = new OneArg(){

        @Override
        protected double evaluate(double d) {
            return Math.asin(d);
        }
    };
    public static final OlapPluginUserJavaFunction ASINH = new OneArg(){

        @Override
        protected double evaluate(double d) {
            return MathX.asinh((double)d);
        }
    };
    public static final OlapPluginUserJavaFunction ATAN = new OneArg(){

        @Override
        protected double evaluate(double d) {
            return Math.atan(d);
        }
    };
    public static final OlapPluginUserJavaFunction ATANH = new OneArg(){

        @Override
        protected double evaluate(double d) {
            return MathX.atanh((double)d);
        }
    };
    public static final OlapPluginUserJavaFunction COS = new OneArg(){

        @Override
        protected double evaluate(double d) {
            return Math.cos(d);
        }
    };
    public static final OlapPluginUserJavaFunction COSH = new OneArg(){

        @Override
        protected double evaluate(double d) {
            return MathX.cosh((double)d);
        }
    };
    public static final OlapPluginUserJavaFunction DEGREES = new OneArg(){

        @Override
        protected double evaluate(double d) {
            return Math.toDegrees(d);
        }
    };
    public static final OlapPluginUserJavaFunction DOLLAR = new OneArg(){

        @Override
        protected double evaluate(double d) {
            return d;
        }
    };
    public static final OlapPluginUserJavaFunction EXP = new OneArg(){

        @Override
        protected double evaluate(double d) {
            return Math.exp(d);
        }
    };
    public static final OlapPluginUserJavaFunction FACT = new OneArg(){

        @Override
        protected double evaluate(double d) {
            return MathX.factorial((int)((int)d));
        }
    };
    public static final OlapPluginUserJavaFunction INT = new OneArg(){

        @Override
        protected double evaluate(double d) {
            return Math.round(d - 0.5);
        }
    };
    public static final OlapPluginUserJavaFunction LN = new OneArg(){

        @Override
        protected double evaluate(double d) {
            return Math.log(d);
        }
    };
    public static final OlapPluginUserJavaFunction LOG10 = new OneArg(){

        @Override
        protected double evaluate(double d) {
            return Math.log(d) / LOG_10_TO_BASE_e;
        }
    };
    public static final OlapPluginUserJavaFunction RADIANS = new OneArg(){

        @Override
        protected double evaluate(double d) {
            return Math.toRadians(d);
        }
    };
    public static final OlapPluginUserJavaFunction SIGN = new OneArg(){

        @Override
        protected double evaluate(double d) {
            return MathX.sign((double)d);
        }
    };
    public static final OlapPluginUserJavaFunction SIN = new OneArg(){

        @Override
        protected double evaluate(double d) {
            return Math.sin(d);
        }
    };
    public static final OlapPluginUserJavaFunction SINH = new OneArg(){

        @Override
        protected double evaluate(double d) {
            return MathX.sinh((double)d);
        }
    };
    public static final OlapPluginUserJavaFunction SQRT = new OneArg(){

        @Override
        protected double evaluate(double d) {
            return Math.sqrt(d);
        }
    };
    public static final OlapPluginUserJavaFunction TAN = new OneArg(){

        @Override
        protected double evaluate(double d) {
            return Math.tan(d);
        }
    };
    public static final OlapPluginUserJavaFunction TANH = new OneArg(){

        @Override
        protected double evaluate(double d) {
            return MathX.tanh((double)d);
        }
    };
    public static final OlapPluginUserJavaFunction ATAN2 = new TwoArg(){

        @Override
        protected double evaluate(double d0, double d1) throws OlapPluginEvaluationException {
            if (d0 == 0.0 && d1 == 0.0) {
                throw new OlapPluginEvaluationException(OlapPluginEvaluationException.Kind.DIV_ZERO);
            }
            return Math.atan2(d1, d0);
        }
    };
    public static final OlapPluginUserJavaFunction CEILING = new TwoArg(){

        @Override
        protected double evaluate(double d0, double d1) {
            return MathX.ceiling((double)d0, (double)d1);
        }
    };
    public static final OlapPluginUserJavaFunction COMBIN = new TwoArg(){

        @Override
        protected double evaluate(double d0, double d1) throws OlapPluginEvaluationException {
            if (d0 > 2.147483647E9 || d1 > 2.147483647E9) {
                throw new OlapPluginEvaluationException(OlapPluginEvaluationException.Kind.NUM_ERROR);
            }
            return MathX.nChooseK((int)((int)d0), (int)((int)d1));
        }
    };
    public static final OlapPluginUserJavaFunction FLOOR = new TwoArg(){

        @Override
        protected double evaluate(double d0, double d1) throws OlapPluginEvaluationException {
            if (d1 == 0.0) {
                if (d0 == 0.0) {
                    return 0.0;
                }
                throw new OlapPluginEvaluationException(OlapPluginEvaluationException.Kind.DIV_ZERO);
            }
            return MathX.floor((double)d0, (double)d1);
        }
    };
    public static final OlapPluginUserJavaFunction MOD = new TwoArg(){

        @Override
        protected double evaluate(double d0, double d1) throws OlapPluginEvaluationException {
            if (d1 == 0.0) {
                throw new OlapPluginEvaluationException(OlapPluginEvaluationException.Kind.DIV_ZERO);
            }
            return MathX.mod((double)d0, (double)d1);
        }
    };
    public static final OlapPluginUserJavaFunction POWER = new TwoArg(){

        @Override
        protected double evaluate(double d0, double d1) {
            return Math.pow(d0, d1);
        }
    };
    public static final OlapPluginUserJavaFunction ROUND = new TwoArg(){

        @Override
        protected double evaluate(double d0, double d1) {
            return MathX.round((double)d0, (int)((int)d1));
        }
    };
    public static final OlapPluginUserJavaFunction ROUNDDOWN = new TwoArg(){

        @Override
        protected double evaluate(double d0, double d1) {
            return MathX.roundDown((double)d0, (int)((int)d1));
        }
    };
    public static final OlapPluginUserJavaFunction ROUNDUP = new TwoArg(){

        @Override
        protected double evaluate(double d0, double d1) {
            return MathX.roundUp((double)d0, (int)((int)d1));
        }
    };
    public static final OlapPluginUserJavaFunction LOG = new MultiArg(1, 2){

        @Override
        protected double evaluate(Double[] ds) {
            double logE = Math.log(ds[0]);
            if (ds.length == 1 || ds[1] == null) {
                return logE / LOG_10_TO_BASE_e;
            }
            double base = ds[1];
            if (base == Math.E) {
                return logE;
            }
            return logE / Math.log(base);
        }
    };

    public static abstract class MultiArg
    extends OlapPluginUserJavaFunction {
        protected MultiArg(int minArgs, int maxArgs) {
            super(minArgs, maxArgs, OlapPluginUserJavaFunction.newArray(Double.TYPE, (int)maxArgs));
        }

        protected final Object doEval(Object[] args) throws OlapPluginEvaluationException {
            Double[] ds = new Double[args.length];
            for (int i = 0; i < ds.length; ++i) {
                ds[i] = (Double)args[i];
            }
            return this.evaluate(ds);
        }

        protected abstract double evaluate(Double[] var1) throws OlapPluginEvaluationException;
    }

    public static abstract class TwoArg
    extends OlapPluginUserJavaFunction {
        protected TwoArg() {
            super(2, new Class[]{Double.TYPE, Double.TYPE});
        }

        public final Object doEval(Object[] args) throws OlapPluginEvaluationException {
            if (args.length != 2) {
                throw new OlapPluginEvaluationException(OlapPluginEvaluationException.Kind.VALUE_INVALID);
            }
            double d0 = (Double)args[0];
            double d1 = (Double)args[1];
            return this.evaluate(d0, d1);
        }

        protected abstract double evaluate(double var1, double var3) throws OlapPluginEvaluationException;
    }

    public static abstract class OneArg
    extends OlapPluginUserJavaFunction {
        protected OneArg() {
            super(1, new Class[]{Double.TYPE});
        }

        public final Object doEval(Object[] args) throws OlapPluginEvaluationException {
            double d = (Double)args[0];
            return this.evaluate(d);
        }

        protected abstract double evaluate(double var1);
    }
}

