/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.plugin.method;

import crazydev.common.javacompiler.DynamicClassLoader;
import crazydev.iccube.mdx.parser.ast.expression.function.MdxFunctionNativeBodyExpression;
import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.function.OlapExecutedWithPreparedInstr;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrVisitor;
import crazydev.iccube.olap.eval.method.OlapJavaMethod;
import crazydev.iccube.olap.eval.method.OlapJavaRegularMethod;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;
import crazydev.iccube.olap.eval.select.context.OlapEvaluationContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.plugin.method.OlapJModuleNativeFunctionPreparedInstr;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.ClassFile;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.SignatureAttribute;
import org.jetbrains.annotations.Nullable;

public class OlapJModuleNativeFunctionInstr
extends OlapExecutedWithPreparedInstr<OlapEvaluationContext> {
    private final MdxFunctionNativeBodyExpression function;
    private final String sourceCode;
    private volatile OlapJavaMethod resolvedMethod;
    private ClassLoader resolvedMethodCL;

    public OlapJModuleNativeFunctionInstr(OlapInstrLocationRange range, MdxFunctionNativeBodyExpression function, String sourceCode) {
        super(range);
        this.function = function;
        this.sourceCode = sourceCode;
    }

    public MdxFunctionNativeBodyExpression getFunction() {
        return this.function;
    }

    public boolean isWithFunction() {
        return this.function.isWithFunction();
    }

    public String getFunctionName() {
        return this.function.getFunctionName();
    }

    public int getFunctionArgCount() {
        return this.function.getFunctionArgCount();
    }

    public String getFunctionArgName(int index) {
        return this.function.getFunctionArgName(index);
    }

    @Nullable
    public String getFunctionArgType(int index) {
        return this.function.getFunctionArgType(index);
    }

    public String getFunctionSourceCode() {
        return this.sourceCode;
    }

    public boolean isNativeJava() {
        return true;
    }

    @Nullable
    public MdxFunctionNativeBodyExpression getNativeFunctionSourceCode() {
        return this.function;
    }

    public String typeForError() {
        return "JAVA NATIVE FUNCTION";
    }

    public void accept(OlapInstrVisitor v) {
        if (v.visit((OlapInstr)this)) {
            // empty if block
        }
    }

    protected OlapPreparedInstr doPrepare(IOlapPrepareContext context) {
        return new OlapJModuleNativeFunctionPreparedInstr(this);
    }

    public OlapJavaMethod resolveJavaNativeMethod(GFContext context) throws ClassNotFoundException, NoSuchMethodException {
        ClassLoader cl = context.getNativeFunctionsClassLoader();
        if (this.resolvedMethod == null || this.resolvedMethodCL != cl) {
            return this.doResolveJavaNativeMethod(context);
        }
        return this.resolvedMethod;
    }

    private synchronized OlapJavaMethod doResolveJavaNativeMethod(GFContext context) throws ClassNotFoundException, NoSuchMethodException {
        ClassLoader cl = context.getNativeFunctionsClassLoader();
        if (this.resolvedMethodCL != cl) {
            this.resolvedMethodCL = cl;
            this.resolvedMethod = null;
        }
        if (this.resolvedMethod != null) {
            return this.resolvedMethod;
        }
        String methodName = this.getFunctionName();
        String className = "icCube.nativeFunctions." + methodName;
        Class<?> clazz = Class.forName(className, true, this.resolvedMethodCL);
        this.resolvedMethod = OlapJModuleNativeFunctionInstr.lookupMethod(clazz, methodName);
        int offset = OlapJModuleNativeFunctionInstr.safeExtractOffset(cl, clazz, this.resolvedMethod);
        this.resolvedMethod.setOffset(offset);
        return this.resolvedMethod;
    }

    private static OlapJavaMethod lookupMethod(Class<?> clazz, String methodName) throws NoSuchMethodException {
        Method[] methods;
        for (Method method : methods = clazz.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return new OlapJavaRegularMethod(method);
        }
        throw new NoSuchMethodException(methodName);
    }

    private static int safeExtractOffset(ClassLoader cl, Class<?> clazz, OlapJavaMethod method) {
        byte[] bc;
        if (cl instanceof DynamicClassLoader && (bc = ((DynamicClassLoader)cl).getByteCode(clazz)) != null) {
            return OlapJModuleNativeFunctionInstr.safeExtractOffset(bc, method);
        }
        return -1;
    }

    private static int safeExtractOffset(byte[] byteCode, OlapJavaMethod method) {
        try {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(byteCode));
            ClassFile jClazz = new ClassFile(in);
            MethodInfo jMethod = OlapJModuleNativeFunctionInstr.getMethodInfo(jClazz, method);
            if (jMethod != null) {
                return jMethod.getLineNumber(0);
            }
            return -1;
        }
        catch (Exception ex) {
            OlapLoggers.MDX_EVALUATION.warn((Object)("[java] could not extract offset for method [" + method.getName() + "]"), (Throwable)ex);
            return -1;
        }
    }

    @Nullable
    private static MethodInfo getMethodInfo(ClassFile clazz, OlapJavaMethod method) throws BadBytecode {
        List methodInfos = clazz.getMethods();
        if (methodInfos == null || methodInfos.isEmpty()) {
            return null;
        }
        ArrayList<MethodInfo> candidates = new ArrayList<MethodInfo>();
        for (MethodInfo methodInfo : methodInfos) {
            if (!methodInfo.getName().equals(method.getName())) continue;
            candidates.add(methodInfo);
        }
        if (candidates.isEmpty()) {
            return null;
        }
        if (candidates.size() == 1) {
            return (MethodInfo)candidates.get(0);
        }
        int pCount = method.getParamCount();
        for (MethodInfo candidate : candidates) {
            String desc = candidate.getDescriptor();
            SignatureAttribute.MethodSignature signature = SignatureAttribute.toMethodSignature((String)desc);
            SignatureAttribute.Type[] types = signature.getParameterTypes();
            int count = types != null ? types.length : 0;
            if (count != pCount) continue;
            return candidate;
        }
        return null;
    }

    public String toStringForDebugger() {
        return "JAVA NATIVE FUNCTION";
    }
}

