/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.searchconsole.v1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.searchconsole.v1.SearchConsoleRequest;
import com.google.api.services.searchconsole.v1.SearchConsoleRequestInitializer;
import com.google.api.services.searchconsole.v1.model.InspectUrlIndexRequest;
import com.google.api.services.searchconsole.v1.model.InspectUrlIndexResponse;
import com.google.api.services.searchconsole.v1.model.RunMobileFriendlyTestRequest;
import com.google.api.services.searchconsole.v1.model.RunMobileFriendlyTestResponse;
import com.google.api.services.searchconsole.v1.model.SearchAnalyticsQueryRequest;
import com.google.api.services.searchconsole.v1.model.SearchAnalyticsQueryResponse;
import com.google.api.services.searchconsole.v1.model.SitemapsListResponse;
import com.google.api.services.searchconsole.v1.model.SitesListResponse;
import com.google.api.services.searchconsole.v1.model.WmxSite;
import com.google.api.services.searchconsole.v1.model.WmxSitemap;
import java.io.IOException;

public class SearchConsole
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://searchconsole.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://searchconsole.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://searchconsole.googleapis.com/";

    public SearchConsole(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    SearchConsole(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Searchanalytics searchanalytics() {
        return new Searchanalytics();
    }

    public Sitemaps sitemaps() {
        return new Sitemaps();
    }

    public Sites sites() {
        return new Sites();
    }

    public UrlInspection urlInspection() {
        return new UrlInspection();
    }

    public UrlTestingTools urlTestingTools() {
        return new UrlTestingTools();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) || GoogleUtils.MAJOR_VERSION >= 2 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 2.0.0 of the Google Search Console API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return SearchConsole.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://searchconsole.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), SearchConsole.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(SearchConsole.DEFAULT_BATCH_PATH);
        }

        public SearchConsole build() {
            return new SearchConsole(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setSearchConsoleRequestInitializer(SearchConsoleRequestInitializer searchconsoleRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)searchconsoleRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }

        public Builder setUniverseDomain(String universeDomain) {
            return (Builder)super.setUniverseDomain(universeDomain);
        }
    }

    public class UrlTestingTools {
        public MobileFriendlyTest mobileFriendlyTest() {
            return new MobileFriendlyTest();
        }

        public class MobileFriendlyTest {
            public Run run(RunMobileFriendlyTestRequest content) throws IOException {
                Run result = new Run(content);
                SearchConsole.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Run
            extends SearchConsoleRequest<RunMobileFriendlyTestResponse> {
                private static final String REST_PATH = "v1/urlTestingTools/mobileFriendlyTest:run";

                protected Run(RunMobileFriendlyTestRequest content) {
                    super(SearchConsole.this, "POST", REST_PATH, (Object)content, RunMobileFriendlyTestResponse.class);
                }

                public Run set$Xgafv(String $Xgafv) {
                    return (Run)super.set$Xgafv($Xgafv);
                }

                public Run setAccessToken(String accessToken) {
                    return (Run)super.setAccessToken(accessToken);
                }

                public Run setAlt(String alt) {
                    return (Run)super.setAlt(alt);
                }

                public Run setCallback(String callback) {
                    return (Run)super.setCallback(callback);
                }

                public Run setFields(String fields) {
                    return (Run)super.setFields(fields);
                }

                public Run setKey(String key) {
                    return (Run)super.setKey(key);
                }

                public Run setOauthToken(String oauthToken) {
                    return (Run)super.setOauthToken(oauthToken);
                }

                public Run setPrettyPrint(Boolean prettyPrint) {
                    return (Run)super.setPrettyPrint(prettyPrint);
                }

                public Run setQuotaUser(String quotaUser) {
                    return (Run)super.setQuotaUser(quotaUser);
                }

                public Run setUploadType(String uploadType) {
                    return (Run)super.setUploadType(uploadType);
                }

                public Run setUploadProtocol(String uploadProtocol) {
                    return (Run)super.setUploadProtocol(uploadProtocol);
                }

                @Override
                public Run set(String parameterName, Object value) {
                    return (Run)super.set(parameterName, value);
                }
            }
        }
    }

    public class UrlInspection {
        public Index index() {
            return new Index();
        }

        public class Index {
            public Inspect inspect(InspectUrlIndexRequest content) throws IOException {
                Inspect result = new Inspect(content);
                SearchConsole.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Inspect
            extends SearchConsoleRequest<InspectUrlIndexResponse> {
                private static final String REST_PATH = "v1/urlInspection/index:inspect";

                protected Inspect(InspectUrlIndexRequest content) {
                    super(SearchConsole.this, "POST", REST_PATH, (Object)content, InspectUrlIndexResponse.class);
                }

                public Inspect set$Xgafv(String $Xgafv) {
                    return (Inspect)super.set$Xgafv($Xgafv);
                }

                public Inspect setAccessToken(String accessToken) {
                    return (Inspect)super.setAccessToken(accessToken);
                }

                public Inspect setAlt(String alt) {
                    return (Inspect)super.setAlt(alt);
                }

                public Inspect setCallback(String callback) {
                    return (Inspect)super.setCallback(callback);
                }

                public Inspect setFields(String fields) {
                    return (Inspect)super.setFields(fields);
                }

                public Inspect setKey(String key) {
                    return (Inspect)super.setKey(key);
                }

                public Inspect setOauthToken(String oauthToken) {
                    return (Inspect)super.setOauthToken(oauthToken);
                }

                public Inspect setPrettyPrint(Boolean prettyPrint) {
                    return (Inspect)super.setPrettyPrint(prettyPrint);
                }

                public Inspect setQuotaUser(String quotaUser) {
                    return (Inspect)super.setQuotaUser(quotaUser);
                }

                public Inspect setUploadType(String uploadType) {
                    return (Inspect)super.setUploadType(uploadType);
                }

                public Inspect setUploadProtocol(String uploadProtocol) {
                    return (Inspect)super.setUploadProtocol(uploadProtocol);
                }

                @Override
                public Inspect set(String parameterName, Object value) {
                    return (Inspect)super.set(parameterName, value);
                }
            }
        }
    }

    public class Sites {
        public Add add(String siteUrl) throws IOException {
            Add result = new Add(siteUrl);
            SearchConsole.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String siteUrl) throws IOException {
            Delete result = new Delete(siteUrl);
            SearchConsole.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String siteUrl) throws IOException {
            Get result = new Get(siteUrl);
            SearchConsole.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            SearchConsole.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends SearchConsoleRequest<SitesListResponse> {
            private static final String REST_PATH = "webmasters/v3/sites";

            protected List() {
                super(SearchConsole.this, "GET", REST_PATH, null, SitesListResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends SearchConsoleRequest<WmxSite> {
            private static final String REST_PATH = "webmasters/v3/sites/{siteUrl}";
            @Key
            private String siteUrl;

            protected Get(String siteUrl) {
                super(SearchConsole.this, "GET", REST_PATH, null, WmxSite.class);
                this.siteUrl = (String)Preconditions.checkNotNull((Object)siteUrl, (Object)"Required parameter siteUrl must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getSiteUrl() {
                return this.siteUrl;
            }

            public Get setSiteUrl(String siteUrl) {
                this.siteUrl = siteUrl;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends SearchConsoleRequest<Void> {
            private static final String REST_PATH = "webmasters/v3/sites/{siteUrl}";
            @Key
            private String siteUrl;

            protected Delete(String siteUrl) {
                super(SearchConsole.this, "DELETE", REST_PATH, null, Void.class);
                this.siteUrl = (String)Preconditions.checkNotNull((Object)siteUrl, (Object)"Required parameter siteUrl must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getSiteUrl() {
                return this.siteUrl;
            }

            public Delete setSiteUrl(String siteUrl) {
                this.siteUrl = siteUrl;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Add
        extends SearchConsoleRequest<Void> {
            private static final String REST_PATH = "webmasters/v3/sites/{siteUrl}";
            @Key
            private String siteUrl;

            protected Add(String siteUrl) {
                super(SearchConsole.this, "PUT", REST_PATH, null, Void.class);
                this.siteUrl = (String)Preconditions.checkNotNull((Object)siteUrl, (Object)"Required parameter siteUrl must be specified.");
            }

            public Add set$Xgafv(String $Xgafv) {
                return (Add)super.set$Xgafv($Xgafv);
            }

            public Add setAccessToken(String accessToken) {
                return (Add)super.setAccessToken(accessToken);
            }

            public Add setAlt(String alt) {
                return (Add)super.setAlt(alt);
            }

            public Add setCallback(String callback) {
                return (Add)super.setCallback(callback);
            }

            public Add setFields(String fields) {
                return (Add)super.setFields(fields);
            }

            public Add setKey(String key) {
                return (Add)super.setKey(key);
            }

            public Add setOauthToken(String oauthToken) {
                return (Add)super.setOauthToken(oauthToken);
            }

            public Add setPrettyPrint(Boolean prettyPrint) {
                return (Add)super.setPrettyPrint(prettyPrint);
            }

            public Add setQuotaUser(String quotaUser) {
                return (Add)super.setQuotaUser(quotaUser);
            }

            public Add setUploadType(String uploadType) {
                return (Add)super.setUploadType(uploadType);
            }

            public Add setUploadProtocol(String uploadProtocol) {
                return (Add)super.setUploadProtocol(uploadProtocol);
            }

            public String getSiteUrl() {
                return this.siteUrl;
            }

            public Add setSiteUrl(String siteUrl) {
                this.siteUrl = siteUrl;
                return this;
            }

            @Override
            public Add set(String parameterName, Object value) {
                return (Add)super.set(parameterName, value);
            }
        }
    }

    public class Sitemaps {
        public Delete delete(String siteUrl, String feedpath) throws IOException {
            Delete result = new Delete(siteUrl, feedpath);
            SearchConsole.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String siteUrl, String feedpath) throws IOException {
            Get result = new Get(siteUrl, feedpath);
            SearchConsole.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String siteUrl) throws IOException {
            List result = new List(siteUrl);
            SearchConsole.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Submit submit(String siteUrl, String feedpath) throws IOException {
            Submit result = new Submit(siteUrl, feedpath);
            SearchConsole.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Submit
        extends SearchConsoleRequest<Void> {
            private static final String REST_PATH = "webmasters/v3/sites/{siteUrl}/sitemaps/{feedpath}";
            @Key
            private String siteUrl;
            @Key
            private String feedpath;

            protected Submit(String siteUrl, String feedpath) {
                super(SearchConsole.this, "PUT", REST_PATH, null, Void.class);
                this.siteUrl = (String)Preconditions.checkNotNull((Object)siteUrl, (Object)"Required parameter siteUrl must be specified.");
                this.feedpath = (String)Preconditions.checkNotNull((Object)feedpath, (Object)"Required parameter feedpath must be specified.");
            }

            public Submit set$Xgafv(String $Xgafv) {
                return (Submit)super.set$Xgafv($Xgafv);
            }

            public Submit setAccessToken(String accessToken) {
                return (Submit)super.setAccessToken(accessToken);
            }

            public Submit setAlt(String alt) {
                return (Submit)super.setAlt(alt);
            }

            public Submit setCallback(String callback) {
                return (Submit)super.setCallback(callback);
            }

            public Submit setFields(String fields) {
                return (Submit)super.setFields(fields);
            }

            public Submit setKey(String key) {
                return (Submit)super.setKey(key);
            }

            public Submit setOauthToken(String oauthToken) {
                return (Submit)super.setOauthToken(oauthToken);
            }

            public Submit setPrettyPrint(Boolean prettyPrint) {
                return (Submit)super.setPrettyPrint(prettyPrint);
            }

            public Submit setQuotaUser(String quotaUser) {
                return (Submit)super.setQuotaUser(quotaUser);
            }

            public Submit setUploadType(String uploadType) {
                return (Submit)super.setUploadType(uploadType);
            }

            public Submit setUploadProtocol(String uploadProtocol) {
                return (Submit)super.setUploadProtocol(uploadProtocol);
            }

            public String getSiteUrl() {
                return this.siteUrl;
            }

            public Submit setSiteUrl(String siteUrl) {
                this.siteUrl = siteUrl;
                return this;
            }

            public String getFeedpath() {
                return this.feedpath;
            }

            public Submit setFeedpath(String feedpath) {
                this.feedpath = feedpath;
                return this;
            }

            @Override
            public Submit set(String parameterName, Object value) {
                return (Submit)super.set(parameterName, value);
            }
        }

        public class List
        extends SearchConsoleRequest<SitemapsListResponse> {
            private static final String REST_PATH = "webmasters/v3/sites/{siteUrl}/sitemaps";
            @Key
            private String siteUrl;
            @Key
            private String sitemapIndex;

            protected List(String siteUrl) {
                super(SearchConsole.this, "GET", REST_PATH, null, SitemapsListResponse.class);
                this.siteUrl = (String)Preconditions.checkNotNull((Object)siteUrl, (Object)"Required parameter siteUrl must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getSiteUrl() {
                return this.siteUrl;
            }

            public List setSiteUrl(String siteUrl) {
                this.siteUrl = siteUrl;
                return this;
            }

            public String getSitemapIndex() {
                return this.sitemapIndex;
            }

            public List setSitemapIndex(String sitemapIndex) {
                this.sitemapIndex = sitemapIndex;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends SearchConsoleRequest<WmxSitemap> {
            private static final String REST_PATH = "webmasters/v3/sites/{siteUrl}/sitemaps/{feedpath}";
            @Key
            private String siteUrl;
            @Key
            private String feedpath;

            protected Get(String siteUrl, String feedpath) {
                super(SearchConsole.this, "GET", REST_PATH, null, WmxSitemap.class);
                this.siteUrl = (String)Preconditions.checkNotNull((Object)siteUrl, (Object)"Required parameter siteUrl must be specified.");
                this.feedpath = (String)Preconditions.checkNotNull((Object)feedpath, (Object)"Required parameter feedpath must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getSiteUrl() {
                return this.siteUrl;
            }

            public Get setSiteUrl(String siteUrl) {
                this.siteUrl = siteUrl;
                return this;
            }

            public String getFeedpath() {
                return this.feedpath;
            }

            public Get setFeedpath(String feedpath) {
                this.feedpath = feedpath;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends SearchConsoleRequest<Void> {
            private static final String REST_PATH = "webmasters/v3/sites/{siteUrl}/sitemaps/{feedpath}";
            @Key
            private String siteUrl;
            @Key
            private String feedpath;

            protected Delete(String siteUrl, String feedpath) {
                super(SearchConsole.this, "DELETE", REST_PATH, null, Void.class);
                this.siteUrl = (String)Preconditions.checkNotNull((Object)siteUrl, (Object)"Required parameter siteUrl must be specified.");
                this.feedpath = (String)Preconditions.checkNotNull((Object)feedpath, (Object)"Required parameter feedpath must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getSiteUrl() {
                return this.siteUrl;
            }

            public Delete setSiteUrl(String siteUrl) {
                this.siteUrl = siteUrl;
                return this;
            }

            public String getFeedpath() {
                return this.feedpath;
            }

            public Delete setFeedpath(String feedpath) {
                this.feedpath = feedpath;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class Searchanalytics {
        public Query query(String siteUrl, SearchAnalyticsQueryRequest content) throws IOException {
            Query result = new Query(siteUrl, content);
            SearchConsole.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Query
        extends SearchConsoleRequest<SearchAnalyticsQueryResponse> {
            private static final String REST_PATH = "webmasters/v3/sites/{siteUrl}/searchAnalytics/query";
            @Key
            private String siteUrl;

            protected Query(String siteUrl, SearchAnalyticsQueryRequest content) {
                super(SearchConsole.this, "POST", REST_PATH, (Object)content, SearchAnalyticsQueryResponse.class);
                this.siteUrl = (String)Preconditions.checkNotNull((Object)siteUrl, (Object)"Required parameter siteUrl must be specified.");
            }

            public Query set$Xgafv(String $Xgafv) {
                return (Query)super.set$Xgafv($Xgafv);
            }

            public Query setAccessToken(String accessToken) {
                return (Query)super.setAccessToken(accessToken);
            }

            public Query setAlt(String alt) {
                return (Query)super.setAlt(alt);
            }

            public Query setCallback(String callback) {
                return (Query)super.setCallback(callback);
            }

            public Query setFields(String fields) {
                return (Query)super.setFields(fields);
            }

            public Query setKey(String key) {
                return (Query)super.setKey(key);
            }

            public Query setOauthToken(String oauthToken) {
                return (Query)super.setOauthToken(oauthToken);
            }

            public Query setPrettyPrint(Boolean prettyPrint) {
                return (Query)super.setPrettyPrint(prettyPrint);
            }

            public Query setQuotaUser(String quotaUser) {
                return (Query)super.setQuotaUser(quotaUser);
            }

            public Query setUploadType(String uploadType) {
                return (Query)super.setUploadType(uploadType);
            }

            public Query setUploadProtocol(String uploadProtocol) {
                return (Query)super.setUploadProtocol(uploadProtocol);
            }

            public String getSiteUrl() {
                return this.siteUrl;
            }

            public Query setSiteUrl(String siteUrl) {
                this.siteUrl = siteUrl;
                return this;
            }

            @Override
            public Query set(String parameterName, Object value) {
                return (Query)super.set(parameterName, value);
            }
        }
    }
}

