/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.OnYourDataVectorSearchAuthenticationOptions;
import com.azure.ai.openai.models.OnYourDataVectorizationSource;
import com.azure.ai.openai.models.OnYourDataVectorizationSourceType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class OnYourDataEndpointVectorizationSource
extends OnYourDataVectorizationSource {
    private final String endpoint;
    private final OnYourDataVectorSearchAuthenticationOptions authentication;
    private OnYourDataVectorizationSourceType type = OnYourDataVectorizationSourceType.ENDPOINT;

    public String getEndpoint() {
        return this.endpoint;
    }

    public OnYourDataVectorSearchAuthenticationOptions getAuthentication() {
        return this.authentication;
    }

    @Override
    public OnYourDataVectorizationSourceType getType() {
        return this.type;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("endpoint", this.endpoint);
        jsonWriter.writeJsonField("authentication", (JsonSerializable)this.authentication);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static OnYourDataEndpointVectorizationSource fromJson(JsonReader jsonReader) throws IOException {
        return (OnYourDataEndpointVectorizationSource)jsonReader.readObject(reader -> {
            String endpoint = null;
            OnYourDataVectorSearchAuthenticationOptions authentication = null;
            OnYourDataVectorizationSourceType type = OnYourDataVectorizationSourceType.ENDPOINT;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("endpoint".equals(fieldName)) {
                    endpoint = reader.getString();
                    continue;
                }
                if ("authentication".equals(fieldName)) {
                    authentication = OnYourDataVectorSearchAuthenticationOptions.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = OnYourDataVectorizationSourceType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            OnYourDataEndpointVectorizationSource deserializedOnYourDataEndpointVectorizationSource = new OnYourDataEndpointVectorizationSource(endpoint, authentication);
            deserializedOnYourDataEndpointVectorizationSource.type = type;
            return deserializedOnYourDataEndpointVectorizationSource;
        });
    }

    public OnYourDataEndpointVectorizationSource(String endpoint, OnYourDataVectorSearchAuthenticationOptions authentication) {
        this.endpoint = endpoint;
        this.authentication = authentication;
    }
}

