/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.ImageGenerationData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.List;

public final class ImageGenerations
implements JsonSerializable<ImageGenerations> {
    private final long createdAt;
    private final List<ImageGenerationData> data;

    private ImageGenerations(OffsetDateTime createdAt, List<ImageGenerationData> data) {
        this.createdAt = createdAt == null ? 0L : createdAt.toEpochSecond();
        this.data = data;
    }

    public OffsetDateTime getCreatedAt() {
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.createdAt), ZoneOffset.UTC);
    }

    public List<ImageGenerationData> getData() {
        return this.data;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeLongField("created", this.createdAt);
        jsonWriter.writeArrayField("data", this.data, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ImageGenerations fromJson(JsonReader jsonReader) throws IOException {
        return (ImageGenerations)jsonReader.readObject(reader -> {
            OffsetDateTime createdAt = null;
            List data = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("created".equals(fieldName)) {
                    createdAt = OffsetDateTime.ofInstant(Instant.ofEpochSecond(reader.getLong()), ZoneOffset.UTC);
                    continue;
                }
                if ("data".equals(fieldName)) {
                    data = reader.readArray(reader1 -> ImageGenerationData.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return new ImageGenerations(createdAt, data);
        });
    }
}

