/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.googleapi.searchconsole.datasource;

import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.searchconsole.v1.SearchConsole;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.GoogleCredentials;
import crazydev.iccube.builder.datasource.OlapBuilderAbstractConnection;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.googleapi.authorization.GoogleCredentialServiceAccountBuilder;
import crazydev.iccube.builder.googleapi.searchconsole.datasource.OlapBuilderGoogleSearchConsole4DataSource;
import crazydev.iccube.builder.model.impl.OlapBuilderBaseDataSource;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import java.io.IOException;
import java.io.Serializable;
import java.security.GeneralSecurityException;

public class OlapBuilderGoogleSearchConsoleConnection
extends OlapBuilderAbstractConnection<OlapBuilderGoogleSearchConsole4DataSource> {
    public static final HttpTransport HTTP_TRANSPORT = new NetHttpTransport();
    public static final JsonFactory JSON_FACTORY = GsonFactory.getDefaultInstance();
    public static final String APPLICATION_NAME = "icCube Local App";

    public OlapBuilderGoogleSearchConsoleConnection(OlapBuilderGoogleSearchConsole4DataSource dataSource) {
        super((OlapBuilderBaseDataSource)dataSource);
    }

    protected void onOpen(OlapRuntimeContext context) throws OlapBuilderErrorException {
    }

    private SearchConsole createDataClient(OlapRuntimeContext context) {
        try {
            GoogleCredentialServiceAccountBuilder builder = new GoogleCredentialServiceAccountBuilder(((OlapBuilderGoogleSearchConsole4DataSource)this.dataSource).getServiceAccountPrivateKey());
            GoogleCredentials credentials = builder.authorize(context, "https://www.googleapis.com/auth/webmasters.readonly");
            SearchConsole service = new SearchConsole.Builder(HTTP_TRANSPORT, JSON_FACTORY, (HttpRequestInitializer)new HttpCredentialsAdapter((Credentials)credentials)).setApplicationName(APPLICATION_NAME).build();
            return service;
        }
        catch (IOException | GeneralSecurityException e) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.IO_ERROR, new Serializable[]{e});
        }
    }

    protected void onClose() {
    }

    public SearchConsole getSearchConsole(OlapRuntimeContext context) {
        return this.createDataClient(context);
    }
}

