/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.googleapi.searchconsole.datasource;

import com.google.api.services.searchconsole.v1.model.SearchAnalyticsQueryRequest;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.xml.CdLocalDateXmlAdapter;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTableRowReader;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.googleapi.OlapBuilderGoogleCommon;
import crazydev.iccube.builder.googleapi.searchconsole.datasource.OlapBuilderGoogleSearchConsole4DataSource;
import crazydev.iccube.builder.googleapi.searchconsole.datasource.OlapBuilderGoogleSearchConsole4RowReader;
import crazydev.iccube.builder.googleapi.searchconsole.datasource.OlapBuilderGoogleSearchConsoleConnection;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumn;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTable;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

@XmlRootElement(name="GSCDataTable")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class OlapBuilderGoogleSearchConsole4DataTable
extends OlapBuilderBaseDataTable<OlapBuilderGoogleSearchConsoleConnection> {
    public static final CdProperty START_DATE = new CdReadWriteProperty(OlapBuilderGoogleSearchConsole4DataTable.class, "startDate", false);
    public static final CdProperty END_DATE = new CdReadWriteProperty(OlapBuilderGoogleSearchConsole4DataTable.class, "endDate", false);
    public static final CdProperty DIMENSIONS = new CdReadWriteProperty(OlapBuilderGoogleSearchConsole4DataTable.class, "dimensions");
    public static final CdProperty MAX_DAYS_FOR_SINGLE_QUERY = new CdReadWriteProperty(OlapBuilderGoogleSearchConsole4DataTable.class, "maxDaysForSingleQuery", false);
    public static final String END_LOAD_DATE_COL_NAME = "icEndLoadDate";
    @XmlAttribute(required=true)
    protected String dimensions = "query,page,country,device,date";
    @XmlAttribute(required=false)
    private Integer maxDaysForSingleQuery;
    @XmlJavaTypeAdapter(value=CdLocalDateXmlAdapter.class)
    @XmlAttribute(required=false)
    @Nullable
    private LocalDate startDate;
    @XmlJavaTypeAdapter(value=CdLocalDateXmlAdapter.class)
    @XmlAttribute(required=false)
    @Nullable
    private LocalDate endDate;

    protected OlapBuilderGoogleSearchConsole4DataTable() {
    }

    protected OlapBuilderGoogleSearchConsole4DataTable(String tableName) {
        super(tableName);
    }

    OlapBuilderGoogleSearchConsole4DataSource getTypedDS() {
        return (OlapBuilderGoogleSearchConsole4DataSource)this.getDataSource();
    }

    public boolean isNameReadOnly() {
        return false;
    }

    public String getInternalFriendlyTypeName() {
        return "GA4 Table";
    }

    public boolean isDiscoveredInDataSource() {
        return false;
    }

    protected List<? extends IOlapBuilderDataColumnDef> doDiscoverAllColumns(OlapRuntimeContext context, OlapBuilderGoogleSearchConsoleConnection connection, OlapBuilderErrorManager errorManager) {
        return this.doDiscoverAllColumnsForRefresh(context, connection, errorManager);
    }

    protected List<? extends IOlapBuilderDataColumnDef> doDiscoverAllColumnsForRefresh(OlapRuntimeContext context, OlapBuilderGoogleSearchConsoleConnection connection, OlapBuilderErrorManager errorManager) {
        ArrayList<OlapBuilderDataColumn> fake = new ArrayList<OlapBuilderDataColumn>();
        if (this.dimensions != null) {
            Arrays.stream(this.dimensions.split(",")).map(String::trim).forEach(s -> fake.add(new OlapBuilderDataColumn(s.equals("date") ? OlapBuilderInputType.DATE : OlapBuilderInputType.STRING, "D-", "D-" + s)));
        }
        fake.add(new OlapBuilderDataColumn(OlapBuilderInputType.INTEGER, "M-", "M-CLICKS"));
        fake.add(new OlapBuilderDataColumn(OlapBuilderInputType.DOUBLE, "M-", "M-POSITIONS"));
        fake.add(new OlapBuilderDataColumn(OlapBuilderInputType.DOUBLE, "M-", "M-CTR"));
        fake.add(new OlapBuilderDataColumn(OlapBuilderInputType.INTEGER, "M-", "M-IMPRESSIONS"));
        return fake;
    }

    @Nullable
    SearchAnalyticsQueryRequest buildRequest(LocalDate startDate) {
        LocalDate maxEndDate;
        LocalDate endDate = this.getTypedDS().getEndDate();
        LocalDate localDate = endDate = endDate == null ? new LocalDate() : endDate;
        if (startDate.isAfter((ReadablePartial)endDate)) {
            return null;
        }
        if (this.maxDaysForSingleQuery != null && (maxEndDate = startDate.plusDays(this.maxDaysForSingleQuery - 1)).isBefore((ReadablePartial)endDate)) {
            endDate = maxEndDate;
        }
        List<String> dimensions = Arrays.stream(this.dimensions.split(",")).map(String::trim).toList();
        SearchAnalyticsQueryRequest request = new SearchAnalyticsQueryRequest().setStartDate(startDate.toString(OlapBuilderGoogleCommon.format)).setEndDate(endDate.toString(OlapBuilderGoogleCommon.format)).setDimensions(dimensions).setRowLimit(Integer.valueOf(this.getTypedDS().getRowLimit()));
        return request;
    }

    protected IOlapBuilderTableRowReader<OlapBuilderGoogleSearchConsoleConnection> doCreateFullTableRowReader(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, int maxRowCount) {
        return new OlapBuilderGoogleSearchConsole4RowReader(context, connectionPool, maxRowCount, this);
    }

    public boolean isRefreshColumnOnUpdate(IOlapBuilderDataTableDef newTable) {
        if (super.isRefreshColumnOnUpdate(newTable)) {
            return true;
        }
        OlapBuilderGoogleSearchConsole4DataTable tableUpdate = (OlapBuilderGoogleSearchConsole4DataTable)newTable;
        return !Objects.equals(this.dimensions, tableUpdate.dimensions);
    }
}

