/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.googleapi.ga4.datasource;

import com.google.analytics.data.v1beta.DateRange;
import com.google.analytics.data.v1beta.Dimension;
import com.google.analytics.data.v1beta.DimensionMetadata;
import com.google.analytics.data.v1beta.GetMetadataRequest;
import com.google.analytics.data.v1beta.Metadata;
import com.google.analytics.data.v1beta.Metric;
import com.google.analytics.data.v1beta.MetricMetadata;
import com.google.analytics.data.v1beta.RunReportRequest;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.xml.CdLocalDateXmlAdapter;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTableRowReader;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.googleapi.OlapBuilderGoogleCommon;
import crazydev.iccube.builder.googleapi.ga4.datasource.OlapBuilderGoogleAnalytics4Connection;
import crazydev.iccube.builder.googleapi.ga4.datasource.OlapBuilderGoogleAnalytics4DataSource;
import crazydev.iccube.builder.googleapi.ga4.datasource.OlapBuilderGoogleAnalytics4RowReader;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumn;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTable;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDate;

@XmlRootElement(name="GA4DataTable")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class OlapBuilderGoogleAnalytics4DataTable
extends OlapBuilderBaseDataTable<OlapBuilderGoogleAnalytics4Connection> {
    public static final CdProperty START_DATE = new CdReadWriteProperty(OlapBuilderGoogleAnalytics4DataTable.class, "startDate", false);
    public static final CdProperty END_DATE = new CdReadWriteProperty(OlapBuilderGoogleAnalytics4DataTable.class, "endDate", false);
    public static final CdProperty DIMENSIONS = new CdReadWriteProperty(OlapBuilderGoogleAnalytics4DataTable.class, "dimensions");
    public static final CdProperty METRICS = new CdReadWriteProperty(OlapBuilderGoogleAnalytics4DataTable.class, "metrics");
    public static final String END_LOAD_DATE_COL_NAME = "icEndLoadDate";
    @XmlAttribute(required=true)
    protected String metrics;
    @XmlAttribute(required=true)
    protected String dimensions;
    @XmlJavaTypeAdapter(value=CdLocalDateXmlAdapter.class)
    @XmlAttribute(required=false)
    @Nullable
    private LocalDate startDate;
    @XmlJavaTypeAdapter(value=CdLocalDateXmlAdapter.class)
    @XmlAttribute(required=false)
    @Nullable
    private LocalDate endDate;

    protected OlapBuilderGoogleAnalytics4DataTable() {
    }

    protected OlapBuilderGoogleAnalytics4DataTable(String tableName) {
        super(tableName);
    }

    OlapBuilderGoogleAnalytics4DataSource getTypedDS() {
        return (OlapBuilderGoogleAnalytics4DataSource)this.getDataSource();
    }

    public boolean isNameReadOnly() {
        return false;
    }

    public String getInternalFriendlyTypeName() {
        return "GA4 Table";
    }

    public boolean isDiscoveredInDataSource() {
        return false;
    }

    protected List<? extends IOlapBuilderDataColumnDef> doDiscoverAllColumns(OlapRuntimeContext context, OlapBuilderGoogleAnalytics4Connection connection, OlapBuilderErrorManager errorManager) {
        return this.doDiscoverAllColumnsForRefresh(context, connection, errorManager);
    }

    protected List<? extends IOlapBuilderDataColumnDef> doDiscoverAllColumnsForRefresh(OlapRuntimeContext context, OlapBuilderGoogleAnalytics4Connection connection, OlapBuilderErrorManager errorManager) {
        ArrayList fake = new ArrayList();
        if (this.dimensions != null) {
            Arrays.stream(this.dimensions.split(",")).map(String::trim).forEach(s -> fake.add(new OlapBuilderDataColumn(OlapBuilderInputType.STRING, "D-" + s, "fake")));
        }
        if (this.metrics != null) {
            Arrays.stream(this.metrics.split(",")).map(String::trim).forEach(s -> fake.add(new OlapBuilderDataColumn(OlapBuilderInputType.DOUBLE, "M-" + s, "fake")));
        }
        Metadata result = connection.getAnalyticsData(context).getMetadata(this.getMetatDataRequest());
        List decoratedColumnns = fake.stream().map(col -> {
            String name = col.getTableType();
            if (name.startsWith("M-")) {
                MetricMetadata meta = OlapBuilderGoogleAnalytics4DataTable.searchMetric(result.getMetricsList(), name.substring(2));
                if (meta != null) {
                    return new OlapBuilderDataColumn(OlapBuilderInputType.STRING, "M-" + meta.getApiName(), meta.getUiName());
                }
                return null;
            }
            DimensionMetadata meta = OlapBuilderGoogleAnalytics4DataTable.searchDimension(result.getDimensionsList(), name.substring(2));
            if (meta != null) {
                OlapBuilderInputType type = OlapBuilderInputType.STRING;
                if (meta.getCategory().equals("Time")) {
                    type = meta.getDescription().contains("YYYYMMDDHH") ? OlapBuilderInputType.DATETIME : OlapBuilderInputType.DATE;
                }
                return new OlapBuilderDataColumn(type, "D-" + meta.getApiName(), meta.getUiName());
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        decoratedColumnns.add(new OlapBuilderDataColumn(OlapBuilderInputType.DATE, "iCube", END_LOAD_DATE_COL_NAME));
        return decoratedColumnns;
    }

    private GetMetadataRequest getMetatDataRequest() {
        return GetMetadataRequest.newBuilder().setName("properties/" + this.getTypedDS().getPropertyId() + "/metadata").build();
    }

    private static MetricMetadata searchMetric(List<MetricMetadata> metricCompatibilitiesList, String search) {
        Optional<MetricMetadata> find = metricCompatibilitiesList.stream().filter(mess -> search.equals(mess.getApiName())).findFirst();
        return find.orElse(null);
    }

    private static DimensionMetadata searchDimension(List<DimensionMetadata> metricCompatibilitiesList, String search) {
        Optional<DimensionMetadata> find = metricCompatibilitiesList.stream().filter(mess -> search.equals(mess.getApiName())).findFirst();
        return find.orElse(null);
    }

    RunReportRequest buildRequest(OlapBuilderContext context, int offset) {
        RunReportRequest.Builder builder = RunReportRequest.newBuilder().setLimit((long)this.getTypedDS().getPageSize()).setOffset((long)offset).setProperty("properties/" + this.getTypedDS().getPropertyId()).addAllDimensions(this.getDimensions(this.getAllColumns())).addAllMetrics(this.getMetrics(this.getAllColumns())).addDateRanges(this.getDataRange());
        Comparable incrLoadMarker = context.getIncrementalLoadMarker((IOlapBuilderDataTableDef)this);
        if (incrLoadMarker != null) {
            String startDate1 = ((LocalDate)incrLoadMarker).toString(OlapBuilderGoogleCommon.format);
            String endDate1 = builder.getDateRanges(0).getEndDate();
            builder.setDateRanges(0, DateRange.newBuilder().setStartDate(startDate1).setEndDate(endDate1).build());
        }
        return builder.build();
    }

    private Iterable<Metric> getMetrics(List<IOlapBuilderDataColumnDef> cols) {
        return cols.stream().filter(col -> col.getTableType().startsWith("M-")).map(col -> Metric.newBuilder().setName(col.getTableType().substring(2)).build()).toList();
    }

    private Iterable<Dimension> getDimensions(List<IOlapBuilderDataColumnDef> cols) {
        return cols.stream().filter(col -> col.getTableType().startsWith("D-")).map(col -> Dimension.newBuilder().setName(col.getTableType().substring(2)).build()).toList();
    }

    private DateRange.Builder getDataRange() {
        LocalDate startDate = this.startDate == null ? this.getTypedDS().getStartDate() : this.startDate;
        LocalDate endDate = this.endDate == null ? this.getTypedDS().getEndDate() : this.endDate;
        DateRange.Builder builder = DateRange.newBuilder();
        builder = startDate != null ? builder.setStartDate(startDate.toString(OlapBuilderGoogleCommon.format)) : builder.setStartDate(new LocalDate(2015, 8, 14).toString(OlapBuilderGoogleCommon.format));
        builder = endDate != null ? builder.setEndDate(endDate.toString(OlapBuilderGoogleCommon.format)) : builder.setEndDate(LocalDate.now().minusDays(1).toString(OlapBuilderGoogleCommon.format));
        return builder;
    }

    protected IOlapBuilderTableRowReader<OlapBuilderGoogleAnalytics4Connection> doCreateFullTableRowReader(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, int maxRowCount) {
        return new OlapBuilderGoogleAnalytics4RowReader(context, connectionPool, maxRowCount, this);
    }

    public boolean isRefreshColumnOnUpdate(IOlapBuilderDataTableDef newTable) {
        if (super.isRefreshColumnOnUpdate(newTable)) {
            return true;
        }
        OlapBuilderGoogleAnalytics4DataTable tableUpdate = (OlapBuilderGoogleAnalytics4DataTable)newTable;
        return !Objects.equals(this.dimensions, tableUpdate.dimensions) || !Objects.equals(this.metrics, tableUpdate.metrics);
    }
}

