/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.googleapi.ga4.datasource;

import com.google.analytics.data.v1beta.BetaAnalyticsDataClient;
import com.google.analytics.data.v1beta.BetaAnalyticsDataSettings;
import com.google.auth.oauth2.ServiceAccountCredentials;
import crazydev.iccube.builder.datasource.OlapBuilderAbstractConnection;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.googleapi.ga4.datasource.OlapBuilderGoogleAnalytics4DataSource;
import crazydev.iccube.builder.model.impl.OlapBuilderBaseDataSource;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;

public class OlapBuilderGoogleAnalytics4Connection
extends OlapBuilderAbstractConnection<OlapBuilderGoogleAnalytics4DataSource> {
    private BetaAnalyticsDataClient dataClient;

    public OlapBuilderGoogleAnalytics4Connection(OlapBuilderGoogleAnalytics4DataSource dataSource) {
        super((OlapBuilderBaseDataSource)dataSource);
    }

    protected void onOpen(OlapRuntimeContext context) throws OlapBuilderErrorException {
    }

    private synchronized BetaAnalyticsDataClient createDataClient(OlapRuntimeContext context) {
        if (this.dataClient != null) {
            return this.dataClient;
        }
        String serviceAccountKeyFile = ((OlapBuilderGoogleAnalytics4DataSource)this.dataSource).getServiceAccountPrivateKey();
        File trusted = context.getUserDefinedFile(serviceAccountKeyFile);
        try {
            ServiceAccountCredentials service = ServiceAccountCredentials.fromStream((InputStream)new FileInputStream(trusted));
            this.dataClient = BetaAnalyticsDataClient.create((BetaAnalyticsDataSettings)((BetaAnalyticsDataSettings.Builder)BetaAnalyticsDataSettings.newBuilder().setCredentialsProvider(() -> service)).build());
            return this.dataClient;
        }
        catch (IOException e) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.IO_ERROR, new Serializable[]{e});
        }
    }

    protected void onClose() {
        if (this.dataClient != null) {
            try {
                this.dataClient.close();
            }
            catch (Exception e) {
                OlapLoggers.BUILDER.warn((Object)"onClose() error", (Throwable)e);
            }
        }
    }

    public BetaAnalyticsDataClient getAnalyticsData(OlapRuntimeContext context) {
        return this.createDataClient(context);
    }
}

