/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.googleapi.drive.datasource;

import crazydev.common.collection.CdFilter;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.iccube.builder.googleapi.drive.datasource.OlapBuilderGoogleDriveDataSource;
import crazydev.iccube.builder.googleapi.drive.datasource.OlapBuilderGoogleSpreadsheetConnection;
import crazydev.iccube.builder.googleapi.drive.datasource.OlapBuilderGoogleSpreadsheetDataSourceUxWizard;
import crazydev.iccube.builder.googleapi.drive.datasource.OlapBuilderGoogleSpreadsheetDataTable;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.ux.meta.datasource.UxBuilderDataSourceType;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="goSpreadsheetDS")
public class OlapBuilderGoogleSpreadsheetDataSource
extends OlapBuilderGoogleDriveDataSource<OlapBuilderGoogleSpreadsheetConnection> {
    public static final CdProperty FILE_NAME = new CdReadWriteProperty(OlapBuilderGoogleSpreadsheetDataSource.class, "fileName");
    public static final CdProperty FILE_ID = new CdReadWriteProperty(OlapBuilderGoogleSpreadsheetDataSource.class, "fileId", false);
    public static final CdProperty TIME_OUT = new CdReadWriteProperty(OlapBuilderGoogleSpreadsheetDataSource.class, "googleTimeOut", false);
    public static final CdProperty CACHE_FILE_SEC = new CdReadWriteProperty(OlapBuilderGoogleSpreadsheetDataSource.class, "cacheFileSec");
    public static final CdProperty WITHOUT_FORMULAS = new CdReadWriteProperty(OlapBuilderGoogleSpreadsheetDataSource.class, "excelWithoutFormulas");
    @XmlAttribute(required=true)
    public String fileName;
    @XmlAttribute(required=true)
    public String fileId;
    @XmlAttribute(required=false)
    public int cacheFileSec;
    @XmlAttribute(required=false)
    private boolean excelWithoutFormulas;
    @XmlTransient
    private OlapBuilderGoogleSpreadsheetConnection cachedConnection;
    @XmlTransient
    private long cacheMillis;
    @XmlAttribute(required=false)
    @Nullable
    private Integer googleTimeOut;

    public OlapBuilderGoogleSpreadsheetDataSource() {
    }

    public OlapBuilderGoogleSpreadsheetDataSource(String serviceAccountPrivateKey, String fileName) {
        super(serviceAccountPrivateKey);
        this.fileName = fileName;
    }

    public String getFileId() {
        return this.fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    protected String getReportDataSourceType() {
        return "googleSpreadsheet";
    }

    protected String getReportDataSourceTypeCaption() {
        return "Google Spreadsheet";
    }

    public boolean isDiscoverTablesSupported() {
        return true;
    }

    @Nullable
    public List<Class<? extends IOlapBuilderTabularDataDef>> getCreatedTableTypes() {
        return null;
    }

    public OlapBuilderGoogleSpreadsheetDataTable createEmptyDiscoverTable(String tableName) {
        return new OlapBuilderGoogleSpreadsheetDataTable(tableName);
    }

    public OlapBuilderGoogleSpreadsheetConnection createConnection(OlapRuntimeContext context, boolean forceRefresh) {
        if (!forceRefresh && this.cachedConnection != null && System.currentTimeMillis() - this.cacheMillis < (long)(this.cacheFileSec * 1000)) {
            return this.cachedConnection;
        }
        OlapBuilderGoogleSpreadsheetConnection connection = new OlapBuilderGoogleSpreadsheetConnection(this, this.cacheFileSec > 0);
        if (this.cacheFileSec > 0) {
            this.cachedConnection = connection;
            this.cacheMillis = System.currentTimeMillis();
        }
        return connection;
    }

    public List<String> discoverAllTablesNames(OlapBuilderGoogleSpreadsheetConnection connection, boolean filterSystemSchemas, @Nullable String filter) {
        return connection.getSheetNames((CdFilter<String>)((CdFilter)sheetName -> this.acceptTableNameForDiscoverTableNames(filter, (String)sheetName)));
    }

    @Override
    @Nullable
    public Integer getTimeout() {
        return this.googleTimeOut;
    }

    public void setExcelWithoutFormulas(boolean excelWithoutFormulas) {
        this.excelWithoutFormulas = excelWithoutFormulas;
    }

    public boolean isWithoutFormulas() {
        return this.excelWithoutFormulas;
    }

    protected UxBuilderDataSourceType createUxType() {
        return new UxBuilderDataSourceType(this.getTypeId(), this.getUxTypeImage(), () -> new OlapBuilderGoogleSpreadsheetDataSourceUxWizard(this, this.getTypeId()));
    }
}

