/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.googleapi.drive.datasource;

import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.File;
import com.google.api.services.drive.model.FileList;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.googleapi.common.OlapBuilderGoogleApiConnection;
import crazydev.iccube.builder.googleapi.drive.datasource.OlapBuilderGoogleDriveDataSource;
import crazydev.iccube.builder.googleapi.errors.OlapGoogleApiError;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OlapBuilderGoogleDriveConnection<DS extends OlapBuilderGoogleDriveDataSource>
extends OlapBuilderGoogleApiConnection<Drive, DS> {
    public OlapBuilderGoogleDriveConnection(DS dataSource) {
        super(dataSource);
    }

    @Override
    protected Drive buildClient(HttpRequestInitializer initializer, HttpTransport httpTransport, JsonFactory jsonFactory) {
        return new Drive.Builder(httpTransport, jsonFactory, initializer).setApplicationName("icCube Local App").build();
    }

    public List<String> getFileNames(@Nullable String filter) throws IOException {
        Drive.Files.List request = ((Drive)this.jsonClient).files().list();
        if (CdStringUtils.isNotNullAndNotBlank((String)filter)) {
            request.setQ("name= '" + OlapBuilderGoogleDriveConnection.googleEscape(filter) + "'");
        }
        ArrayList<String> names = new ArrayList<String>();
        do {
            FileList files = (FileList)request.execute();
            files.getFiles().forEach(file -> names.add(file.getName()));
            request.setPageToken(files.getNextPageToken());
        } while (names.size() < 100 && request.getPageToken() != null && request.getPageToken().length() > 0);
        return names;
    }

    protected String getMimeQ() {
        return "";
    }

    File getFile(Drive jsonClient, @Nullable String fileId, String fileName) throws IOException {
        if (CdStringUtils.isNotNullAndNotBlank((String)fileId)) {
            return (File)jsonClient.files().get(fileId).execute();
        }
        Drive.Files.List request = jsonClient.files().list();
        request.setQ("name= '" + OlapBuilderGoogleDriveConnection.googleEscape(fileName) + "'" + this.getMimeQ());
        do {
            FileList files = (FileList)request.execute();
            for (File file : files.getFiles()) {
                String filename = file.getName();
                if (!filename.equals(fileName)) continue;
                return file;
            }
            request.setPageToken(files.getNextPageToken());
        } while (request.getPageToken() != null && request.getPageToken().length() > 0);
        throw new OlapBuilderErrorException(OlapGoogleApiError.GOOGLE_DRIVE_MISSING_FILE_NAME, new Serializable[]{fileName});
    }

    private static String googleEscape(String fileName) {
        return fileName.replaceAll("'", "\\'");
    }

    @Override
    public String getAccountScope() {
        return "https://www.googleapis.com/auth/drive.readonly";
    }

    static void checkCredentialAndThrow(HttpRequestInitializer credential) {
        try {
            Drive client = OlapBuilderGoogleDriveConnection.buildClient(credential);
            client.drives().list().execute();
        }
        catch (IOException e) {
            throw new RuntimeException("No Authorization to access Google Drive : " + e.getMessage());
        }
    }

    File checkFile(HttpRequestInitializer credential, String fileId, String fileName) throws IOException {
        return this.getFile(OlapBuilderGoogleDriveConnection.buildClient(credential), fileId, fileName);
    }

    @NotNull
    private static Drive buildClient(HttpRequestInitializer credential) {
        return new Drive.Builder(HTTP_TRANSPORT, JSON_FACTORY, credential).setApplicationName("icCube Local App").build();
    }
}

