/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.googleapi.common;

import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.GoogleCredentials;
import crazydev.iccube.builder.datasource.OlapBuilderAbstractConnection;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.googleapi.authorization.OlapBuilderGoogleCredentialBuilder;
import crazydev.iccube.builder.googleapi.common.OlapBuilderGoogleApiDataSource;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.request.IcCubeRequest;
import java.io.Serializable;
import org.apache.log4j.Logger;

public abstract class OlapBuilderGoogleApiConnection<T, DATASOURCE extends OlapBuilderGoogleApiDataSource>
extends OlapBuilderAbstractConnection<DATASOURCE> {
    public static final Logger LOGGER = OlapLoggers.BUILDER_GOOGLE;
    public static final String APPLICATION_NAME = "icCube Local App";
    public static final HttpTransport HTTP_TRANSPORT = new NetHttpTransport();
    public static final JsonFactory JSON_FACTORY = GsonFactory.getDefaultInstance();
    protected T jsonClient;

    public OlapBuilderGoogleApiConnection(DATASOURCE dataSource) {
        super(dataSource);
    }

    public T getJsonClient() {
        return this.jsonClient;
    }

    public void onOpen(OlapRuntimeContext context) throws OlapBuilderErrorException {
        try {
            IcCubeRequest.assertNotCancelled((String)"add-member");
            HttpRequestInitializer initializer = this.setTimeout(this.authorize(context));
            IcCubeRequest.assertNotCancelled((String)"add-member");
            this.jsonClient = this.buildClient(initializer, HTTP_TRANSPORT, JSON_FACTORY);
        }
        catch (Exception ex) {
            throw new OlapBuilderErrorException((Throwable)ex, OlapBuilderErrorCode.IO_ERROR, new Serializable[]{ex.getMessage()});
        }
    }

    protected HttpRequestInitializer setTimeout(GoogleCredentials credential) {
        Integer timeout = ((OlapBuilderGoogleApiDataSource)this.dataSource).getTimeout();
        if (timeout == null || timeout == 0) {
            return new HttpCredentialsAdapter((Credentials)credential);
        }
        return httpRequest -> {
            new HttpCredentialsAdapter((Credentials)credential).initialize(httpRequest);
            httpRequest.setConnectTimeout(timeout * 1000);
            httpRequest.setReadTimeout(timeout * 1000);
        };
    }

    protected abstract T buildClient(HttpRequestInitializer var1, HttpTransport var2, JsonFactory var3);

    protected void onClose() {
        this.jsonClient = null;
    }

    protected GoogleCredentials authorize(OlapRuntimeContext context) throws Exception {
        OlapBuilderGoogleCredentialBuilder builder = ((OlapBuilderGoogleApiDataSource)this.dataSource).getCredentialBuilder(context);
        return builder.authorize(context, this.getAccountScope());
    }

    public abstract String getAccountScope();
}

