/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.googleapi.bigquery.datasource;

import crazydev.common.utils.CdLog4jUtils;
import crazydev.common.utils.CdSizeUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.apache.logging.log4j.Level;

public class SimbaShell {
    public static void main(String[] args) {
        CdLog4jUtils.configure((Level)Level.DEBUG);
        Logger.getLogger((String)"io.grpc").setLevel(org.apache.log4j.Level.INFO);
        GcInfoLogger gc = new GcInfoLogger(200);
        gc.start();
        long procStartMS = System.currentTimeMillis();
        AtomicInteger rowNB = new AtomicInteger();
        rowNB.addAndGet(SimbaShell.safeMainPeople(null));
        long procEndMS = System.currentTimeMillis();
        OlapLoggers.GENERAL.info((Object)("request completed : " + rowNB.get() + " " + (int)((double)(procEndMS - procStartMS) / 1000.0) + "s"));
        gc.stop();
    }

    public static int safeMainPeople(Boolean male) {
        try {
            return SimbaShell.mainPeople(male);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    public static int mainPeople(Boolean male) throws SQLException {
        long procStartMS;
        OlapLoggers.GENERAL.info((Object)"started.1");
        Connection connection = DriverManager.getConnection("jdbc:bigquery://https://www.googleapis.com/bigquery/v2:443;ProjectId=iccube.com:iccube-main;OAuthType=0;OAuthServiceAcctEmail=unit-testing@iccube-main.iccube.com.iam.gserviceaccount.com;OAuthPvtKeyPath=/home/mpo/icCube/google-api/voila.json;EnableHighThroughputAPI=1;AllowLargeResults=0;LogLevel=4;");
        connection.setReadOnly(true);
        String sql = "select * from Test.natality_group_by" + (String)(male != null ? " where is_male = " + male : "");
        OlapLoggers.GENERAL.info((Object)"started.2");
        PreparedStatement statement = connection.prepareStatement(sql, 1003, 1007);
        statement.setFetchSize(1000);
        long startMS = procStartMS = System.currentTimeMillis();
        OlapLoggers.GENERAL.info((Object)"started.3");
        ResultSet resultSet = statement.executeQuery();
        long endMS = System.currentTimeMillis();
        OlapLoggers.GENERAL.info((Object)("query executed : " + (endMS - startMS) + "ms"));
        long procStartMS_ = endMS;
        int rowNB = 0;
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        startMS = endMS;
        while (resultSet.next()) {
            if (rowNB % 100000 == 0) {
                endMS = System.currentTimeMillis();
                OlapLoggers.GENERAL.info((Object)(rowNB + " : " + (endMS - startMS) + "ms : " + CdStringUtils.formatNice((long)((int)((double)(100000L / (endMS - startMS)) * 1000.0))) + "r/s"));
                startMS = endMS;
            }
            ++rowNB;
            Object year = resultSet.getObject(1);
            Object state = resultSet.getObject(2);
            Object is_male = resultSet.getObject(3);
            Object mother_age = resultSet.getObject(4);
            Object father_age = resultSet.getObject(5);
            Object mother_married = resultSet.getObject(6);
            Object cigarettes_per_day = resultSet.getObject(7);
            Object drinks_per_week = resultSet.getObject(8);
            Object sum_weight_pounds = resultSet.getObject(9);
            Object count_born = resultSet.getObject(10);
            Object female_count = resultSet.getObject(11);
            Object male_count = resultSet.getObject(12);
            rows.add(new Object[]{year, state, is_male, mother_age, father_age, mother_married, cigarettes_per_day, drinks_per_week, sum_weight_pounds, count_born, female_count, male_count});
        }
        resultSet.close();
        statement.close();
        long procEndMS = System.currentTimeMillis();
        OlapLoggers.GENERAL.info((Object)("request completed : " + rowNB + " WITH-QUERY:" + (int)((double)((long)rowNB / (procEndMS - procStartMS)) * 1000.0) + "r/s " + (int)((double)((long)rowNB / (procEndMS - procStartMS_)) * 1000.0) + "r/s"));
        OlapLoggers.GENERAL.info((Object)("request completed : " + rowNB + " " + (int)((double)(procEndMS - procStartMS) / 1000.0) + "s"));
        return rowNB;
    }

    static class GcInfoLogger {
        private final Map<GarbageCollectorMXBean, GcInfo> gcInfos = new IdentityHashMap<GarbageCollectorMXBean, GcInfo>();
        private final Thread thread;
        private volatile boolean requestToStop;

        GcInfoLogger(final int millis) {
            this.thread = new Thread(new Runnable(){
                final /* synthetic */ GcInfoLogger this$0;
                {
                    GcInfoLogger gcInfoLogger = this$0;
                    Objects.requireNonNull(gcInfoLogger);
                    this.this$0 = gcInfoLogger;
                }

                @Override
                public void run() {
                    while (!this.this$0.requestToStop) {
                        try {
                            Thread.sleep(millis);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        try {
                            List<GarbageCollectorMXBean> beans = ManagementFactory.getGarbageCollectorMXBeans();
                            int size = beans.size();
                            for (int ii = 0; ii < size; ++ii) {
                                long updateMS;
                                GarbageCollectorMXBean bean = beans.get(ii);
                                GcInfo gcInfo = this.this$0.gcInfos.get(bean);
                                if (gcInfo == null) {
                                    gcInfo = new GcInfo(bean);
                                    this.this$0.gcInfos.put(bean, gcInfo);
                                }
                                if ((updateMS = gcInfo.update()) == -1L) continue;
                                String max = CdSizeUtils.format((double)Runtime.getRuntime().maxMemory());
                                String total = CdSizeUtils.format((double)Runtime.getRuntime().totalMemory());
                                String free = CdSizeUtils.format((double)Runtime.getRuntime().freeMemory());
                                String info = " ( free:" + free + " / total:" + total + " / max:" + max + " )";
                                String name = gcInfo.bean.getName();
                                String update = updateMS + "ms";
                                OlapLoggers.GENERAL.warn((Object)("[GC] (" + name + ") : " + update + info));
                            }
                        }
                        catch (Exception ex) {
                            OlapLoggers.GENERAL.fatal((Object)"[GC] error : ", (Throwable)ex);
                            break;
                        }
                    }
                }
            }, "gc");
        }

        public void start() {
            this.thread.start();
        }

        public void stop() {
            this.requestToStop = true;
            this.thread.interrupt();
        }
    }

    static class GcInfo {
        private final GarbageCollectorMXBean bean;
        private long latestTime;

        public GcInfo(GarbageCollectorMXBean bean) {
            this.bean = bean;
            this.latestTime = bean.getCollectionTime();
        }

        public long update() {
            long time = this.bean.getCollectionTime();
            if (time > this.latestTime) {
                long update = time - this.latestTime;
                this.latestTime = time;
                return update;
            }
            return -1L;
        }
    }
}

