/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.googleapi.bigquery.datasource;

import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableId;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.utils.CdSql;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTableRowReader;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.factory.schema.IOlapBuilderJaxbListener;
import crazydev.iccube.builder.googleapi.bigquery.datasource.OlapBuilderGoogleBigQueryStorageDataTableRowReader;
import crazydev.iccube.builder.googleapi.bigquery.datasource.OlapBuilderGoogleBigqueryBaseDataTable;
import crazydev.iccube.builder.googleapi.bigquery.datasource.OlapBuilderGoogleBigqueryConnection;
import crazydev.iccube.builder.googleapi.bigquery.datasource.OlapBuilderGoogleBigqueryDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="goBigqueryTableDT")
public class OlapBuilderGoogleBigqueryDataTable
extends OlapBuilderGoogleBigqueryBaseDataTable
implements IOlapBuilderJaxbListener {
    public static final CdProperty TABLEID = new CdReadWriteProperty(OlapBuilderGoogleBigqueryDataTable.class, "tableId", true);
    public static final CdProperty DATASET = new CdReadWriteProperty(OlapBuilderGoogleBigqueryDataTable.class, "datasetId", false);
    public static final CdProperty VERSION = new CdReadWriteProperty(OlapBuilderGoogleBigqueryDataTable.class, "v", false, false);
    public static final CdProperty RESTRICTIONS = new CdReadWriteProperty(OlapBuilderGoogleBigqueryDataTable.class, "restrictions", false, true){

        public Class<?> getTypeForDefaultEditor() {
            return CdSql.class;
        }
    };
    public static final CdProperty USE_STORAGE_API = new CdReadWriteProperty(OlapBuilderGoogleBigqueryDataTable.class, "useStorageApi", false);
    public static final CdProperty USE_LEGACY_CODE = new CdReadWriteProperty(OlapBuilderGoogleBigqueryDataTable.class, "useLegacyCode", true);
    @XmlAttribute(required=true)
    protected String tableId;
    @XmlAttribute
    protected String datasetId;
    @XmlAttribute
    protected Integer v = 1;
    @XmlAttribute
    protected String restrictions;
    @XmlAttribute
    private Boolean useLegacyCode;
    @XmlAttribute
    private Boolean useStorageApi;

    public OlapBuilderGoogleBigqueryDataTable() {
    }

    public OlapBuilderGoogleBigqueryDataTable(String tableName, String tableId, String datasetId, boolean useLegacyCode) {
        super(tableName);
        this.tableId = tableId;
        this.datasetId = datasetId;
        this.useLegacyCode = useLegacyCode;
    }

    public TableId getApiTableId(OlapBuilderGoogleBigqueryConnection connection) {
        OlapBuilderGoogleBigqueryDataSource ds = (OlapBuilderGoogleBigqueryDataSource)connection.getDataSource();
        String projectId = ds.getProjectId();
        String dataSetId = this.getDataSetId(connection);
        return TableId.of((String)projectId, (String)dataSetId, (String)this.tableId);
    }

    @Override
    protected String getDataSetId(OlapBuilderGoogleBigqueryConnection connection) {
        return CdStringUtils.isNullOrBlank((String)this.datasetId) ? super.getDataSetId(connection) : this.datasetId;
    }

    @Override
    protected IOlapBuilderTableRowReader<OlapBuilderGoogleBigqueryConnection> doCreateFullTableRowReader(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, int maxRowCount) {
        if (this.useStorageApi()) {
            return new OlapBuilderGoogleBigQueryStorageDataTableRowReader(context, connectionPool, maxRowCount, this);
        }
        return super.doCreateFullTableRowReader(context, connectionPool, maxRowCount);
    }

    @Override
    protected List<? extends IOlapBuilderDataColumnDef> doDiscoverAllColumns(OlapRuntimeContext context, OlapBuilderGoogleBigqueryConnection openedConnection, OlapBuilderErrorManager errorManager) {
        BigQuery jsonClient = openedConnection.getJsonClient();
        Table table = jsonClient.getTable(this.getApiTableId(openedConnection), new BigQuery.TableOption[0]);
        Schema schema = table.getDefinition().getSchema();
        if (schema == null) {
            return super.doDiscoverAllColumns(context, openedConnection, errorManager);
        }
        return this.toColumns(schema.getFields());
    }

    public String getInternalFriendlyTypeName() {
        return "Google BigQuery Table";
    }

    @Override
    protected boolean useLegacyCode() {
        return this.useLegacyCode == Boolean.TRUE;
    }

    public boolean useStorageApi() {
        return this.useStorageApi == Boolean.TRUE;
    }

    public void setUseStorageApi(boolean useStorageApi) {
        this.useStorageApi = useStorageApi;
    }

    private String addBrackets(String name) {
        return this.useLegacyCode() ? "[" + name + "]" : "`" + name + "`";
    }

    @Override
    protected String buildSelect(OlapBuilderGoogleBigqueryConnection connection, @Nullable Comparable incrLoadMarker) {
        StringBuilder builder = new StringBuilder("SELECT ");
        List selectedColumns = this.getSelectedColumns();
        for (int i = 0; i < selectedColumns.size(); ++i) {
            IOlapBuilderDataColumnDef columnDef = (IOlapBuilderDataColumnDef)selectedColumns.get(i);
            builder.append(i == 0 ? "" : ",").append(this.addBrackets(columnDef.getName()));
        }
        if (selectedColumns.isEmpty()) {
            builder.append("*");
        }
        TableId apiTableId = this.getApiTableId(connection);
        String rscName = apiTableId.getProject() + "." + apiTableId.getDataset() + "." + apiTableId.getTable();
        builder.append(" FROM ").append(this.addBrackets(rscName));
        boolean hasRestrictions = CdStringUtils.isNotNullAndNotBlank((String)this.restrictions);
        if (hasRestrictions) {
            if (incrLoadMarker == null) {
                builder.append(" WHERE ").append(this.restrictions);
            } else {
                builder.append(" WHERE (").append(this.restrictions).append(")");
            }
        }
        if (incrLoadMarker != null) {
            String restriction = this.setupIncrLoadRestriction(rscName, incrLoadMarker);
            if (!hasRestrictions) {
                builder.append(" WHERE ").append(restriction);
            } else {
                builder.append(" AND ").append(restriction);
            }
        }
        return builder.toString();
    }

    @Nullable
    public List<String> getRestrictionList() {
        if (CdStringUtils.isNullOrBlank((String)this.restrictions)) {
            return null;
        }
        String[] lines = this.restrictions.split("\\R");
        if (lines == null || lines.length == 0) {
            return null;
        }
        ArrayList<String> statements = new ArrayList<String>();
        for (String line : lines) {
            if (!CdStringUtils.isNotNullAndNotBlank((String)line)) continue;
            statements.add(line.trim());
        }
        return statements;
    }

    public void beforeMarshal() {
    }

    public void afterUnmarshal() {
        if (this.v == null) {
            this.datasetId = TableFormatter.getDataSetId(this.tableId);
            this.tableId = TableFormatter.getTableId(this.tableId);
            this.v = 1;
        }
    }

    private static class TableFormatter {
        private TableFormatter() {
        }

        @Nullable
        public static String getDataSetId(String tableId) {
            String[] s1 = tableId.split(":");
            String table = s1.length == 0 ? "" : s1[s1.length - 1];
            String[] s2 = table.split("\\.");
            return s2.length == 1 ? null : s2[0];
        }

        public static String getTableId(String tableId) {
            String[] s2 = tableId.split("\\.");
            return s2.length <= 1 ? tableId : s2[s2.length - 1];
        }
    }
}

