/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.googleapi.bigquery.datasource;

import com.google.cloud.RetryOption;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldList;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.JobStatistics;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardSQLTypeName;
import com.google.cloud.bigquery.TableResult;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTableRowReader;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.googleapi.bigquery.datasource.OlapBuilderGoogleBigQueryDataTableRowReader;
import crazydev.iccube.builder.googleapi.bigquery.datasource.OlapBuilderGoogleBigqueryConnection;
import crazydev.iccube.builder.googleapi.bigquery.datasource.OlapBuilderGoogleBigqueryDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderConnection;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumn;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTable;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.IOException;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.ISODateTimeFormat;

public abstract class OlapBuilderGoogleBigqueryBaseDataTable
extends OlapBuilderBaseDataTable<OlapBuilderGoogleBigqueryConnection> {
    protected OlapBuilderGoogleBigqueryBaseDataTable() {
    }

    public OlapBuilderGoogleBigqueryBaseDataTable(String tableName) {
        super(tableName);
    }

    protected IOlapBuilderTableRowReader<OlapBuilderGoogleBigqueryConnection> doCreateFullTableRowReader(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, int maxRowCount) {
        return new OlapBuilderGoogleBigQueryDataTableRowReader(context, connectionPool, maxRowCount, this);
    }

    protected List<? extends IOlapBuilderDataColumnDef> doDiscoverAllColumnsForRefresh(OlapRuntimeContext context, OlapBuilderGoogleBigqueryConnection connection, OlapBuilderErrorManager errorManager) {
        return this.discoverAllColumns(context, (IOlapBuilderConnection)connection, errorManager);
    }

    protected List<? extends IOlapBuilderDataColumnDef> doDiscoverAllColumns(OlapRuntimeContext context, OlapBuilderGoogleBigqueryConnection openedConnection, OlapBuilderErrorManager errorManager) {
        try {
            Schema schema = this.executeQuery4Discover(openedConnection, this);
            return this.toColumns(schema.getFields());
        }
        catch (IOException | InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected TableResult executeQuery(OlapBuilderGoogleBigqueryConnection connection, int maxRowCount, OlapBuilderGoogleBigqueryBaseDataTable table, @Nullable Comparable incrLoadMarker) throws IOException, InterruptedException {
        Job job = this.createJob(connection, maxRowCount, table, incrLoadMarker);
        return maxRowCount > 0 ? job.getQueryResults(new BigQuery.QueryResultsOption[]{BigQuery.QueryResultsOption.pageSize((long)maxRowCount)}) : job.getQueryResults(new BigQuery.QueryResultsOption[0]);
    }

    protected Schema executeQuery4Discover(OlapBuilderGoogleBigqueryConnection connection, OlapBuilderGoogleBigqueryBaseDataTable table) throws IOException, InterruptedException {
        Job queryJob = this.createJob(connection, 0, table, null);
        JobStatistics.QueryStatistics statistics = (JobStatistics.QueryStatistics)queryJob.getStatistics();
        Schema schema = statistics.getSchema();
        if (schema != null) {
            return schema;
        }
        TableResult result = this.executeQuery(connection, 1, table, null);
        return result.getSchema();
    }

    private Job createJob(OlapBuilderGoogleBigqueryConnection connection, int maxRowCount, OlapBuilderGoogleBigqueryBaseDataTable table, @Nullable Comparable incrLoadMarker) throws InterruptedException {
        boolean dryRun;
        String query = table.buildSelect(connection, incrLoadMarker);
        OlapLoggers.BUILDER_GOOGLE.debug((Object)String.format("[big-query] table [%s] select statement: %s", this.getName(), query));
        QueryJobConfiguration.Builder builder = QueryJobConfiguration.newBuilder((String)query).setUseLegacySql(Boolean.valueOf(this.useLegacyCode()));
        OlapBuilderGoogleBigqueryDataSource ds = (OlapBuilderGoogleBigqueryDataSource)this.getDataSource();
        if (CdStringUtils.isNotNullAndNotBlank((String)ds.getDatasetId())) {
            builder.setDefaultDataset(ds.getDatasetId());
        }
        if (ds.getWaitTime() != null && ds.getWaitTime() != 0) {
            builder.setJobTimeoutMs(Long.valueOf(1000L * (long)ds.getWaitTime().intValue()));
        }
        boolean bl = dryRun = maxRowCount == 0;
        if (dryRun) {
            builder.setDryRun(Boolean.valueOf(true));
        }
        QueryJobConfiguration queryConfig = builder.build();
        JobId jobId = JobId.of((String)UUID.randomUUID().toString());
        JobInfo jobInfo = JobInfo.newBuilder((JobConfiguration)queryConfig).setJobId(jobId).build();
        Job queryJob = connection.getJsonClient().create(jobInfo, new BigQuery.JobOption[0]);
        if (!dryRun) {
            queryJob = queryJob.waitFor(new RetryOption[0]);
        }
        if (queryJob == null) {
            throw new RuntimeException("Job no longer exists");
        }
        if (queryJob.getStatus().getError() != null) {
            throw new RuntimeException(queryJob.getStatus().getError().toString());
        }
        return queryJob;
    }

    protected abstract boolean useLegacyCode();

    protected String getProjectId(OlapBuilderGoogleBigqueryConnection connection) {
        return ((OlapBuilderGoogleBigqueryDataSource)connection.getDataSource()).getProjectId();
    }

    protected String getDataSetId(OlapBuilderGoogleBigqueryConnection connection) {
        return ((OlapBuilderGoogleBigqueryDataSource)connection.getDataSource()).getDatasetId();
    }

    protected abstract String buildSelect(OlapBuilderGoogleBigqueryConnection var1, @Nullable Comparable var2);

    protected List<? extends IOlapBuilderDataColumnDef> toColumns(FieldList fields) {
        ArrayList<OlapBuilderDataColumn> cols = new ArrayList<OlapBuilderDataColumn>();
        for (Field field : fields) {
            cols.add(this.toColumn(field));
        }
        return cols;
    }

    private OlapBuilderDataColumn toColumn(Field field) {
        StandardSQLTypeName type = field.getType().getStandardType();
        return new OlapBuilderDataColumn(this.toColumnType(type), type.toString(), field.getName());
    }

    private OlapBuilderInputType toColumnType(StandardSQLTypeName type) {
        switch (type) {
            case GEOGRAPHY: 
            case STRING: {
                return OlapBuilderInputType.STRING;
            }
            case INT64: {
                return OlapBuilderInputType.LONG;
            }
            case NUMERIC: 
            case FLOAT64: {
                return OlapBuilderInputType.DOUBLE;
            }
            case BOOL: {
                return OlapBuilderInputType.BOOLEAN;
            }
            case DATETIME: 
            case TIMESTAMP: {
                return OlapBuilderInputType.DATETIME;
            }
            case DATE: {
                return OlapBuilderInputType.DATE;
            }
            case TIME: {
                return OlapBuilderInputType.LONG;
            }
        }
        return OlapBuilderInputType.JAVA_OBJECT;
    }

    @Nullable
    public Integer getWaitTime() {
        return ((OlapBuilderGoogleBigqueryDataSource)this.getDataSource()).getWaitTime();
    }

    protected String setupIncrLoadRestriction(String tableNameQ, Comparable incrLoadMarker) {
        String columnName = this.getIncrementalLoadColumnName();
        IOlapBuilderDataColumnDef columnDef = this.getSelectedColumn(columnName);
        String columnTableType = columnDef.getTableType();
        String restriction = columnName + " > " + this.setupIncrLoadRestrictionValue(tableNameQ, incrLoadMarker);
        OlapLoggers.BUILDER_GOOGLE.debug((Object)String.format("[big-query] table [%s] setup incr. load restriction [%s] [marker:%s] [marker-class:%s] [col-type:%s]", tableNameQ, restriction, incrLoadMarker, incrLoadMarker.getClass().getName(), columnTableType));
        return restriction;
    }

    protected String setupIncrLoadRestrictionValue(String tableNameQ, Comparable incrLoadMarker) {
        String columnName = this.getIncrementalLoadColumnName();
        IOlapBuilderDataColumnDef columnDef = this.getSelectedColumn(columnName);
        String columnTableType = columnDef.getTableType();
        String restriction = String.valueOf(incrLoadMarker);
        if (incrLoadMarker instanceof Number && "TIME".equals(columnTableType)) {
            LocalTime time = LocalTime.ofNanoOfDay(1000L * ((Number)((Object)incrLoadMarker)).longValue());
            restriction = "TIME(DATETIME \"2020-01-01 " + String.valueOf(time) + "\")";
        } else if (incrLoadMarker instanceof LocalDateTime && "TIMESTAMP".equals(columnTableType)) {
            DateTimeFormatter dateTimeF = new DateTimeFormatterBuilder().append(ISODateTimeFormat.date()).appendLiteral(" ").append(ISODateTimeFormat.time()).toFormatter();
            String dateTime = dateTimeF.print((ReadablePartial)((LocalDateTime)incrLoadMarker));
            restriction = "TIMESTAMP(\"" + dateTime + "\")";
        } else if (incrLoadMarker instanceof LocalDateTime && "DATETIME".equals(columnTableType)) {
            DateTimeFormatter dateTimeF = new DateTimeFormatterBuilder().append(ISODateTimeFormat.date()).appendLiteral(" ").append(ISODateTimeFormat.time()).toFormatter();
            String dateTime = dateTimeF.print((ReadablePartial)((LocalDateTime)incrLoadMarker));
            restriction = "DATETIME(TIMESTAMP \"" + dateTime + "\")";
        } else if (incrLoadMarker instanceof LocalDate && "DATE".equals(columnTableType)) {
            LocalDate date = (LocalDate)incrLoadMarker;
            restriction = "DATE(" + date.getYear() + "," + date.getMonthOfYear() + "," + date.getDayOfMonth() + ")";
        }
        OlapLoggers.BUILDER_GOOGLE.debug((Object)String.format("[big-query] table [%s] setup incr. load restriction value [%s] [marker:%s] [marker-class:%s] [col-type:%s]", tableNameQ, restriction, incrLoadMarker, incrLoadMarker.getClass().getName(), columnTableType));
        return restriction;
    }
}

