/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.googleapi.bigquery.datasource;

import com.google.api.gax.rpc.ServerStream;
import com.google.cloud.bigquery.storage.v1.ArrowSchema;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import crazydev.iccube.builder.googleapi.bigquery.datasource.OlapBuilderGoogleBigQueryStorageStream;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderGoogleBigQueryStorageStreams {
    private final String tableNameQ;
    private final ArrowSchema schema;
    private final ServerStream<ReadRowsResponse>[] streams;
    private int createdStreamCount;
    private int closedStreamCount;
    private OlapBuilderGoogleBigQueryStorageStream currentStream;
    private int currentStreamIdx;

    public OlapBuilderGoogleBigQueryStorageStreams(String tableNameQ, ArrowSchema schema, ServerStream<ReadRowsResponse>[] streams) throws IOException {
        this.tableNameQ = tableNameQ;
        this.schema = schema;
        this.streams = streams;
        if (streams.length > 0) {
            this.currentStreamIdx = 0;
            this.currentStream = new OlapBuilderGoogleBigQueryStorageStream(this, "0", streams[0]);
        } else {
            this.currentStreamIdx = -1;
            this.currentStream = null;
        }
    }

    public String getTableNameQ() {
        return this.tableNameQ;
    }

    public ArrowSchema getSchema() {
        return this.schema;
    }

    public void incrementCreatedStreamCount() {
        ++this.createdStreamCount;
    }

    public void incrementClosedStreamCount() {
        ++this.closedStreamCount;
    }

    @Nullable
    public IOlapBuilderTableRow nextRow() throws IOException {
        while (this.currentStream != null) {
            IOlapBuilderTableRow row = this.currentStream.nextRow();
            if (row != null) {
                return row;
            }
            if (++this.currentStreamIdx < this.streams.length) {
                this.currentStream.close();
                this.currentStream = new OlapBuilderGoogleBigQueryStorageStream(this, String.valueOf(this.currentStreamIdx), this.streams[this.currentStreamIdx]);
                continue;
            }
            this.currentStream.close();
            this.currentStream = null;
        }
        return null;
    }

    public void close() {
        if (this.currentStream != null) {
            this.currentStream.close();
            this.currentStream = null;
        }
        OlapLoggers.BUILDER_GOOGLE.debug((Object)("[big-query-storage] table [" + this.getTableNameQ() + "] closed session current stream: " + this.currentStreamIdx + " [stream-count:" + this.streams.length + "]"));
        for (int ii = this.currentStreamIdx + 1; ii < this.streams.length; ++ii) {
            this.streams[ii].cancel();
        }
        OlapLoggers.BUILDER_GOOGLE.debug((Object)("[big-query-storage] table [" + this.getTableNameQ() + "] closed session streams:" + this.streams.length + " [" + this.createdStreamCount + "][" + this.closedStreamCount + "]"));
    }
}

