/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.googleapi.bigquery.datasource;

import com.google.api.gax.rpc.ServerStream;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import crazydev.iccube.builder.googleapi.bigquery.datasource.OlapBuilderGoogleBigQueryStorageStreamResponse;
import crazydev.iccube.builder.googleapi.bigquery.datasource.OlapBuilderGoogleBigQueryStorageStreams;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.IOException;
import java.util.Iterator;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderGoogleBigQueryStorageStream {
    private final OlapBuilderGoogleBigQueryStorageStreams streams;
    private final String streamName;
    private final Iterator<ReadRowsResponse> stream;
    private OlapBuilderGoogleBigQueryStorageStreamResponse currentResponse;
    private int rowCount;
    private int createdDecoderCount;
    private int closedDecoderCount;

    public OlapBuilderGoogleBigQueryStorageStream(OlapBuilderGoogleBigQueryStorageStreams streams, String streamName, ServerStream<ReadRowsResponse> stream) throws IOException {
        OlapLoggers.BUILDER_GOOGLE.debug((Object)("[big-query-storage] table [" + streams.getTableNameQ() + "] session stream: " + streamName));
        this.streams = streams;
        this.streams.incrementCreatedStreamCount();
        this.streamName = streamName;
        this.stream = stream.iterator();
        this.currentResponse = this.stream.hasNext() ? new OlapBuilderGoogleBigQueryStorageStreamResponse(this, streams.getSchema(), this.stream.next()) : null;
    }

    public void incrementCreatedDecoderCount() {
        ++this.createdDecoderCount;
    }

    public void incrementClosedDecoderCount() {
        ++this.closedDecoderCount;
    }

    @Nullable
    public IOlapBuilderTableRow nextRow() throws IOException {
        while (this.currentResponse != null) {
            IOlapBuilderTableRow row = this.currentResponse.nextRow();
            if (row != null) {
                ++this.rowCount;
                return row;
            }
            if (this.stream.hasNext()) {
                this.currentResponse.close();
                this.currentResponse = new OlapBuilderGoogleBigQueryStorageStreamResponse(this, this.streams.getSchema(), this.stream.next());
                continue;
            }
            this.currentResponse.close();
            this.currentResponse = null;
        }
        return null;
    }

    public void close() {
        this.streams.incrementClosedStreamCount();
        if (this.currentResponse != null) {
            this.currentResponse.close();
            this.currentResponse = null;
        }
        OlapLoggers.BUILDER_GOOGLE.debug((Object)("[big-query-storage] table [" + this.streams.getTableNameQ() + "] closed session stream: " + this.streamName + " [rows:" + this.rowCount + "] [" + this.createdDecoderCount + "][" + this.closedDecoderCount + "]"));
    }
}

