/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.googleapi.bigquery.datasource;

import com.google.api.gax.rpc.ServerStream;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.auth.Credentials;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.storage.v1.BigQueryReadClient;
import com.google.cloud.bigquery.storage.v1.BigQueryReadSettings;
import com.google.cloud.bigquery.storage.v1.CreateReadSessionRequest;
import com.google.cloud.bigquery.storage.v1.DataFormat;
import com.google.cloud.bigquery.storage.v1.ReadRowsRequest;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.reader.OlapBuilderAbstractTableRowReader;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.googleapi.bigquery.datasource.OlapBuilderGoogleBigQueryStorageStreams;
import crazydev.iccube.builder.googleapi.bigquery.datasource.OlapBuilderGoogleBigqueryConnection;
import crazydev.iccube.builder.googleapi.bigquery.datasource.OlapBuilderGoogleBigqueryDataSource;
import crazydev.iccube.builder.googleapi.bigquery.datasource.OlapBuilderGoogleBigqueryDataTable;
import crazydev.iccube.builder.googleapi.errors.OlapGoogleApiError;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderGoogleBigQueryStorageDataTableRowReader
extends OlapBuilderAbstractTableRowReader<OlapBuilderGoogleBigqueryDataTable, OlapBuilderGoogleBigqueryConnection> {
    @Nullable
    private String tableNameQ;
    @Nullable
    private BigQueryReadClient client;
    @Nullable
    private OlapBuilderGoogleBigQueryStorageStreams streams;
    private int rowsCount;

    public OlapBuilderGoogleBigQueryStorageDataTableRowReader(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, int maxRowCount, OlapBuilderGoogleBigqueryDataTable table) {
        super(context, connectionPool, maxRowCount, (IOlapBuilderDataTableDef)table, table.getName());
    }

    public void doInit() {
        this.initConnection();
        OlapBuilderGoogleBigqueryDataSource ds = (OlapBuilderGoogleBigqueryDataSource)((OlapBuilderGoogleBigqueryDataTable)this.table).getDataSource();
        String parentProjectId = ds.getCredentialsProjectId();
        TableId apiTableId = ((OlapBuilderGoogleBigqueryDataTable)this.table).getApiTableId((OlapBuilderGoogleBigqueryConnection)this.connection);
        String dsProjectId = apiTableId.getProject();
        String dataSetId = apiTableId.getDataset();
        String tableId = apiTableId.getTable();
        this.tableNameQ = dsProjectId + "." + dataSetId + "." + tableId;
        OlapLoggers.BUILDER_GOOGLE.debug((Object)("[big-query-storage] init session for table [" + this.tableNameQ + "]"));
        String parent = String.format("projects/%s", parentProjectId);
        String srcTable = apiTableId.getIAMResourceName();
        Credentials credentials = ((OlapBuilderGoogleBigqueryConnection)this.connection).getCredentials();
        try {
            Comparable incrLoadMarker;
            BigQueryReadSettings settings = ((BigQueryReadSettings.Builder)BigQueryReadSettings.newBuilder().setCredentialsProvider(() -> credentials)).build();
            this.client = BigQueryReadClient.create((BigQueryReadSettings)settings);
            List columns = ((OlapBuilderGoogleBigqueryDataTable)this.table).getSelectedColumns();
            ReadSession.TableReadOptions.Builder optionsBuilder = ReadSession.TableReadOptions.newBuilder();
            for (Object column : columns) {
                optionsBuilder.addSelectedFields(column.getName());
            }
            List<String> restrictions = ((OlapBuilderGoogleBigqueryDataTable)this.table).getRestrictionList();
            if (restrictions != null) {
                for (String restriction : restrictions) {
                    optionsBuilder.setRowRestriction(restriction);
                }
            }
            if ((incrLoadMarker = this.context.getIncrementalLoadMarker(this.table)) != null) {
                String restriction;
                restriction = ((OlapBuilderGoogleBigqueryDataTable)this.table).setupIncrLoadRestriction(this.tableNameQ, incrLoadMarker);
                optionsBuilder.setRowRestriction(restriction);
                OlapLoggers.BUILDER_GOOGLE_BQS.debug((Object)String.format("[big-query-storage] table [%s] incr. load restriction [%s]", this.tableNameQ, restriction));
            }
            ReadSession.Builder sessionBuilder = ReadSession.newBuilder().setTable(srcTable).setDataFormat(DataFormat.ARROW).setReadOptions(optionsBuilder);
            CreateReadSessionRequest.Builder builder = CreateReadSessionRequest.newBuilder().setParent(parent).setReadSession(sessionBuilder);
            if (this.maxRowCount != -1) {
                builder.setMaxStreamCount(1);
            }
            ReadSession session = this.client.createReadSession(builder.build());
            int streamCount = session.getStreamsCount();
            OlapLoggers.BUILDER_GOOGLE.debug((Object)("[big-query-storage] table [" + this.tableNameQ + "] session stream count:" + streamCount));
            ServerStream[] streams = new ServerStream[streamCount];
            try {
                for (int streamIndex = 0; streamIndex < streams.length; ++streamIndex) {
                    ServerStream stream;
                    String streamName = session.getStreams(streamIndex).getName();
                    ReadRowsRequest readRowsRequest = ReadRowsRequest.newBuilder().setReadStream(streamName).build();
                    ServerStreamingCallable callable = this.client.readRowsCallable();
                    streams[streamIndex] = stream = callable.call((Object)readRowsRequest);
                }
                this.streams = new OlapBuilderGoogleBigQueryStorageStreams(this.tableNameQ, session.getArrowSchema(), streams);
            }
            catch (RuntimeException ex) {
                OlapLoggers.BUILDER_GOOGLE_BQS.error((Object)("[big-query-storage] table [" + this.tableNameQ + "] error (cancelling created streams)"), (Throwable)ex);
                this.cancelCreatedStreamsSilently(streams);
                throw ex;
            }
        }
        catch (IOException ex) {
            throw new OlapBuilderErrorException((Throwable)ex, OlapGoogleApiError.IO_ERROR, new Serializable[]{ex.getLocalizedMessage()});
        }
    }

    private void cancelCreatedStreamsSilently(ServerStream<ReadRowsResponse>[] streams) {
        for (int ii = 0; ii < streams.length; ++ii) {
            ServerStream<ReadRowsResponse> stream = streams[ii];
            if (stream == null) continue;
            try {
                stream.cancel();
                continue;
            }
            catch (RuntimeException ex) {
                OlapLoggers.BUILDER_GOOGLE_BQS.error((Object)("[big-query-storage] table [" + this.tableNameQ + "] error while cancelling the created stream[" + ii + "]"), (Throwable)ex);
            }
        }
    }

    public boolean isRowSafe() {
        return false;
    }

    public IOlapBuilderTableRow doNextRow() {
        if (this.maxRowCount != -1 && this.rowsCount >= this.maxRowCount) {
            return null;
        }
        if (this.streams == null) {
            return null;
        }
        try {
            IOlapBuilderTableRow row = this.streams.nextRow();
            if (row == null) {
                return null;
            }
            ++this.rowsCount;
            return row;
        }
        catch (IOException ex) {
            throw new OlapBuilderErrorException((Throwable)ex, OlapGoogleApiError.IO_ERROR, new Serializable[]{ex.getLocalizedMessage()});
        }
    }

    public void done() {
        OlapLoggers.BUILDER_GOOGLE.debug((Object)("[big-query-storage] closing table row reader [" + (this.tableNameQ != null ? this.tableNameQ : ((OlapBuilderGoogleBigqueryDataTable)this.table).getName()) + "]"));
        if (this.streams != null) {
            try {
                this.streams.close();
                this.streams = null;
            }
            catch (RuntimeException ex) {
                OlapLoggers.BUILDER_GOOGLE_BQS.info((Object)"[big-query-storage] could not close the streams", (Throwable)ex);
            }
        }
        if (this.client != null) {
            try {
                this.client.close();
                this.client = null;
            }
            catch (RuntimeException ex) {
                OlapLoggers.BUILDER_GOOGLE_BQS.info((Object)"[big-query-storage] could not close the client", (Throwable)ex);
            }
        }
        super.done();
    }
}

