/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.googleapi.bigquery.datasource;

import com.google.cloud.bigquery.storage.v1.ArrowRecordBatch;
import com.google.cloud.bigquery.storage.v1.ArrowSchema;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.def.OlapBuilderAbstractTableRow;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.VectorLoader;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ReadChannel;
import org.apache.arrow.vector.ipc.message.MessageSerializer;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.ByteArrayReadableSeekableByteChannel;
import org.apache.arrow.vector.util.Text;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public class OlapBuilderGoogleBigQueryStorageArrowResponseDecoder {
    private final BufferAllocator allocator = new RootAllocator(Long.MAX_VALUE);
    private final VectorSchemaRoot root;
    private final VectorLoader loader;
    private final int batchRowCount;
    private int nextRow;

    public OlapBuilderGoogleBigQueryStorageArrowResponseDecoder(ArrowSchema arrowSchema, ArrowRecordBatch batch) throws IOException {
        Schema schema = MessageSerializer.deserializeSchema((ReadChannel)new ReadChannel((ReadableByteChannel)new ByteArrayReadableSeekableByteChannel(arrowSchema.getSerializedSchema().toByteArray())));
        ArrayList<FieldVector> vectors = new ArrayList<FieldVector>();
        List fields = schema.getFields();
        for (Field field : fields) {
            vectors.add(field.createVector(this.allocator));
        }
        this.root = new VectorSchemaRoot(vectors);
        this.loader = new VectorLoader(this.root);
        org.apache.arrow.vector.ipc.message.ArrowRecordBatch deserializedBatch = MessageSerializer.deserializeRecordBatch((ReadChannel)new ReadChannel((ReadableByteChannel)new ByteArrayReadableSeekableByteChannel(batch.getSerializedRecordBatch().toByteArray())), (BufferAllocator)this.allocator);
        this.loader.load(deserializedBatch);
        deserializedBatch.close();
        this.batchRowCount = this.root.getRowCount();
        this.nextRow = 0;
    }

    @Nullable
    public IOlapBuilderTableRow nextRow() {
        if (this.nextRow >= this.batchRowCount) {
            return null;
        }
        final int row = this.nextRow++;
        final List vectors = this.root.getFieldVectors();
        return new OlapBuilderAbstractTableRow(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Nullable
            protected Object getDataImpl(IOlapBuilderDataColumnDef columnDef) {
                int columnIdx = columnDef.getIndex();
                FieldVector vector = (FieldVector)vectors.get(columnIdx);
                Object value = vector.getObject(row);
                if (value == null) {
                    return null;
                }
                ArrowType.ArrowTypeID typeID = vector.getField().getFieldType().getType().getTypeID();
                switch (typeID) {
                    case Utf8: 
                    case LargeUtf8: {
                        Text text = (Text)value;
                        return text.toString();
                    }
                    case Timestamp: {
                        long epoch = value instanceof java.time.LocalDateTime ? ((java.time.LocalDateTime)value).toInstant(ZoneOffset.UTC).toEpochMilli() : (Long)value / 1000L;
                        return new LocalDateTime((Object)new Date(epoch), DateTimeZone.UTC);
                    }
                    case Date: {
                        int days = (Integer)value;
                        long epoch = (long)days * 86400L * 1000L;
                        return new LocalDate((Object)new Date(epoch), DateTimeZone.UTC);
                    }
                    case Time: {
                        return ((Number)value).longValue();
                    }
                }
                return value instanceof Comparable ? (Comparable)value : null;
            }
        };
    }

    public void close() {
        this.root.close();
        this.allocator.close();
    }
}

