/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.server.iccube.server.message.session;

import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.xmla.model.message.session.XmlaEndSessionQuery;
import crazydev.xmla.server.iccube.server.engine.XmlaQueryContext;
import crazydev.xmla.server.iccube.server.engine.XmlaQuerySessionContext;
import crazydev.xmla.server.iccube.server.engine.XmlaServerProxy;
import crazydev.xmla.server.iccube.server.message.XmlaQueryHandler;
import crazydev.xmla.server.iccube.server.message.XmlaResponse;
import crazydev.xmla.server.iccube.server.message.session.XmlaEndSessionResponse;
import jakarta.servlet.http.HttpSession;
import org.jetbrains.annotations.Nullable;

public class XmlaEndSessionQueryHandler
extends XmlaQueryHandler<XmlaEndSessionQuery> {
    @Override
    protected XmlaResponse doHandle(XmlaQueryContext context, XmlaEndSessionQuery request) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("XMLA : executing EndSession [" + request.getSessionId() + "]"));
        }
        XmlaServerProxy xmlaEngine = context.getXmlaEngine();
        XmlaEndSessionQueryHandler.closeSession(xmlaEngine, request.getSessionId());
        return new XmlaEndSessionResponse(request.getSessionId());
    }

    @Override
    protected XmlaResponse doHandleForPrepare(XmlaQueryContext context, XmlaEndSessionQuery request) {
        throw new RuntimeException("internal error : ExecutionMode=Prepare not supported for EndSession");
    }

    public static void closeSession(XmlaServerProxy xmlaEngine, @Nullable String sessionId) {
        HttpSession httpSession;
        XmlaQuerySessionContext destroyedSession = xmlaEngine.closeSession(sessionId);
        if (destroyedSession != null && (httpSession = destroyedSession.getHttpSession()) != null) {
            if (OlapLoggers.SESSIONS.isInfoEnabled()) {
                OlapLoggers.SESSIONS.info((Object)("[session] XMLA session is invalidating its bound HTTP session [ " + destroyedSession.getSessionId() + " / " + httpSession.getId() + " ]"));
            }
            httpSession.removeAttribute("icCubeServer.xmlaSessionContext");
            httpSession.invalidate();
        }
    }
}

