/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.server.iccube.server.message.execute.rsc;

import crazydev.common.exception.CdRuntimeException;
import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.utils.CdResourceUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;

public abstract class XmlaResource {
    public static String getResource(String name, boolean trim) {
        try {
            String line;
            StringBuilder sb = new StringBuilder();
            String schema = CdResourceUtils.getResourceAsString(XmlaResource.class, (String)name);
            BufferedReader in = new BufferedReader(new StringReader(schema));
            boolean ignore = true;
            while ((line = in.readLine()) != null) {
                if (ignore && (line.startsWith("<xs:schema ") || line.startsWith("<xsd:schema "))) {
                    ignore = false;
                }
                if (ignore) continue;
                if (!trim) {
                    sb.append(line);
                    continue;
                }
                sb.append(" ").append(line.trim());
            }
            if (ignore) {
                throw new CdProgrammingException("Missing schema information [" + XmlaResource.class.getName() + "][" + name + "]!");
            }
            return sb.toString();
        }
        catch (IOException ex) {
            throw new CdRuntimeException((Throwable)ex, "Schema information error [" + XmlaResource.class.getName() + "][" + name + "]!");
        }
    }
}

