/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.server.iccube.server.message.execute.dmv;

import crazydev.xmla.model.discover.IXmlaDiscover;
import crazydev.xmla.model.discover.IXmlaMDSchemaLevel;
import crazydev.xmla.model.types.XmlaLevelType;
import crazydev.xmla.server.iccube.rowset.IXmlaDiscoverRowSetColumn;
import crazydev.xmla.server.iccube.rowset.XmlaDiscoverRowSet;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.ArrayConstructor;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.schema.Column;
import org.jetbrains.annotations.Nullable;

public abstract class XmlaDmvRestriction {
    public static XmlaDmvRestriction fromExpr(@Nullable Expression expr) throws JSQLParserException {
        Expression expression = expr;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EqualsTo.class, NotEqualsTo.class, AndExpression.class, ArrayConstructor.class}, (Expression)expression, n)) {
            case 0 -> {
                EqualsTo eq = (EqualsTo)expression;
                yield XmlaDmvRestriction.fromEqualsTo(eq);
            }
            case 1 -> {
                NotEqualsTo neq = (NotEqualsTo)expression;
                yield XmlaDmvRestriction.fromNotEqualsTo(neq);
            }
            case 2 -> {
                AndExpression and = (AndExpression)expression;
                yield XmlaDmvRestriction.fromAnd(and);
            }
            case 3 -> {
                ArrayConstructor arr = (ArrayConstructor)expression;
                yield XmlaDmvRestriction.fromArrayConstructor((Expression)arr);
            }
            case -1 -> XmlaDmvRestriction.fromNull();
            default -> throw new JSQLParserException("Unexpected restriction expression [" + String.valueOf(expr) + "]");
        };
    }

    private static XmlaDmvRestriction fromValueExpr(Expression expr) throws JSQLParserException {
        Expression expression = expr;
        Objects.requireNonNull(expression);
        Expression expression2 = expression;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LongValue.class, StringValue.class}, (Expression)expression2, n)) {
            case 0 -> {
                LongValue lv = (LongValue)expression2;
                yield XmlaDmvRestriction.fromLongValue(lv);
            }
            case 1 -> {
                StringValue lv = (StringValue)expression2;
                yield XmlaDmvRestriction.fromStringValue(lv);
            }
            default -> throw new JSQLParserException("Unexpected value expression [" + String.valueOf(expr) + "]");
        };
    }

    private static XmlaDmvRestriction fromNull() {
        return new XmlaDmvRestrictionNop();
    }

    private static XmlaDmvRestrictionField fromArrayConstructor(Expression expr) throws JSQLParserException {
        Expression item;
        ArrayConstructor arr;
        ExpressionList items;
        if (expr instanceof ArrayConstructor && (items = (arr = (ArrayConstructor)expr).getExpressions()).size() == 1 && (item = (Expression)items.getFirst()) instanceof Column) {
            Column itemC = (Column)item;
            return new XmlaDmvRestrictionField(itemC.getColumnName());
        }
        throw new JSQLParserException("Unexpected (array constructor) restriction expression [" + String.valueOf(expr) + "]");
    }

    private static XmlaDmvRestrictionEquals fromEqualsTo(EqualsTo expr) throws JSQLParserException {
        XmlaDmvRestrictionField left = XmlaDmvRestriction.fromArrayConstructor(expr.getLeftExpression());
        XmlaDmvRestriction right = XmlaDmvRestriction.fromValueExpr(expr.getRightExpression());
        return new XmlaDmvRestrictionEquals(left, right);
    }

    private static XmlaDmvRestrictionNotEquals fromNotEqualsTo(NotEqualsTo expr) throws JSQLParserException {
        XmlaDmvRestrictionField left = XmlaDmvRestriction.fromArrayConstructor(expr.getLeftExpression());
        XmlaDmvRestriction right = XmlaDmvRestriction.fromValueExpr(expr.getRightExpression());
        return new XmlaDmvRestrictionNotEquals(left, right);
    }

    private static XmlaDmvRestrictionAnd fromAnd(AndExpression expr) throws JSQLParserException {
        XmlaDmvRestriction left = XmlaDmvRestriction.fromExpr(expr.getLeftExpression());
        XmlaDmvRestriction right = XmlaDmvRestriction.fromExpr(expr.getRightExpression());
        return new XmlaDmvRestrictionAnd(left, right);
    }

    private static XmlaDmvRestrictionLV fromLongValue(LongValue value) {
        return new XmlaDmvRestrictionLV(value.getValue());
    }

    private static XmlaDmvRestrictionSV fromStringValue(StringValue value) {
        return new XmlaDmvRestrictionSV(value.getValue());
    }

    public abstract boolean accept(XmlaDiscoverRowSet var1, IXmlaDiscover var2);

    public Object getValue() {
        throw new RuntimeException("internal error : unexpected value usage");
    }

    private static class XmlaDmvRestrictionEquals
    extends XmlaDmvRestriction {
        private final XmlaDmvRestrictionField left;
        private final XmlaDmvRestriction right;

        public XmlaDmvRestrictionEquals(XmlaDmvRestrictionField left, XmlaDmvRestriction right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean accept(XmlaDiscoverRowSet rowSetDef, IXmlaDiscover row) {
            IXmlaDiscoverRowSetColumn col = rowSetDef.getColumnByName(this.left.name);
            if (col == null) {
                return true;
            }
            String restrictionValue = this.right.getValue().toString();
            boolean accepted = !col.restrictionMatches(row, restrictionValue);
            return accepted;
        }

        public String toString() {
            return String.valueOf(this.left) + " == " + String.valueOf(this.right);
        }
    }

    private static class XmlaDmvRestrictionNotEquals
    extends XmlaDmvRestriction {
        private final XmlaDmvRestrictionField left;
        private final XmlaDmvRestriction right;

        public XmlaDmvRestrictionNotEquals(XmlaDmvRestrictionField left, XmlaDmvRestriction right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean accept(XmlaDiscoverRowSet rowSetDef, IXmlaDiscover row) {
            IXmlaDiscoverRowSetColumn col = rowSetDef.getColumnByName(this.left.name);
            if (col == null) {
                return true;
            }
            String restrictionValue = this.right.getValue().toString();
            if ("LEVEL_NAME".equals(this.left.name) && "(All)".equals(restrictionValue) && row instanceof IXmlaMDSchemaLevel) {
                IXmlaMDSchemaLevel rowL = (IXmlaMDSchemaLevel)row;
                XmlaLevelType levelType = rowL.getLevelType();
                boolean accepted = levelType != XmlaLevelType.MDLEVEL_TYPE_ALL;
                return accepted;
            }
            boolean accepted = col.restrictionMatches(row, restrictionValue);
            return accepted;
        }

        public String toString() {
            return String.valueOf(this.left) + " != " + String.valueOf(this.right);
        }
    }

    private static class XmlaDmvRestrictionAnd
    extends XmlaDmvRestriction {
        private final XmlaDmvRestriction left;
        private final XmlaDmvRestriction right;

        public XmlaDmvRestrictionAnd(XmlaDmvRestriction left, XmlaDmvRestriction right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean accept(XmlaDiscoverRowSet rowSetDef, IXmlaDiscover row) {
            boolean leftA = this.left.accept(rowSetDef, row);
            boolean rightA = this.right.accept(rowSetDef, row);
            return leftA && rightA;
        }

        public String toString() {
            return String.valueOf(this.left) + " AND " + String.valueOf(this.right);
        }
    }

    private static class XmlaDmvRestrictionField
    extends XmlaDmvRestriction {
        private final String name;

        public XmlaDmvRestrictionField(String name) {
            this.name = name;
        }

        @Override
        public boolean accept(XmlaDiscoverRowSet rowSetDef, IXmlaDiscover row) {
            IXmlaDiscoverRowSetColumn col = rowSetDef.getColumnByName(this.name);
            if (col == null) {
                return true;
            }
            boolean restrictionValue = col.isTrue(row);
            return restrictionValue;
        }

        public String toString() {
            return this.name;
        }
    }

    private static class XmlaDmvRestrictionLV
    extends XmlaDmvRestriction {
        private final long value;

        private XmlaDmvRestrictionLV(long value) {
            this.value = value;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public boolean accept(XmlaDiscoverRowSet rowSetDef, IXmlaDiscover row) {
            throw new RuntimeException("internal error : unexpected filter usage");
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class XmlaDmvRestrictionSV
    extends XmlaDmvRestriction {
        private final String value;

        private XmlaDmvRestrictionSV(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public boolean accept(XmlaDiscoverRowSet rowSetDef, IXmlaDiscover row) {
            throw new RuntimeException("internal error : unexpected filter usage");
        }

        public String toString() {
            return this.value;
        }
    }

    private static class XmlaDmvRestrictionNop
    extends XmlaDmvRestriction {
        @Override
        public boolean accept(XmlaDiscoverRowSet rowSetDef, IXmlaDiscover row) {
            return true;
        }
    }
}

