/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.server.iccube.server.message.execute;

import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationApplicationFeatureException;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationException;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.command.builtin.OlapEngineUnloadPartitionsParams;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaLifeCycleStatus;
import crazydev.iccube.olap.component.command.builtin.OlapUnloadPartitionsHelper;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.schema.OlapSchemaInformation;
import crazydev.xmla.model.message.execute.XmlaExecuteQuery;
import crazydev.xmla.model.message.execute.XmlaUnloadPartitionsStatementCommandQuery;
import crazydev.xmla.server.iccube.server.engine.XmlaQueryContext;
import crazydev.xmla.server.iccube.server.message.XmlaResponse;
import crazydev.xmla.server.iccube.server.message.common.XmlaManagementApiQueryHandler;
import java.io.File;

public class XmlaUnloadPartitionsStatementCommandQueryHandler
extends XmlaManagementApiQueryHandler<XmlaUnloadPartitionsStatementCommandQuery> {
    @Override
    protected void assertRequestAuthorized(XmlaQueryContext context, OlapRoleApplicationPermissions permissions, XmlaUnloadPartitionsStatementCommandQuery request) throws OlapRoleAuthorizationException {
        super.assertRequestAuthorized(context, permissions, request);
        if (!context.isFactsPartitioningLicensed() || !context.isTablePartitioningLicensed()) {
            throw new OlapRoleAuthorizationApplicationFeatureException("app.server", "app.server.managementApi.partitions");
        }
    }

    @Override
    protected XmlaResponse doExecuteOlapEngineRequest(XmlaQueryContext context, XmlaUnloadPartitionsStatementCommandQuery request, OlapEngineRequestContext requestContext) {
        OlapSchemaInformation info;
        String schemaName = request.getSchema();
        if (schemaName == null) {
            throw new RuntimeException("internal error: inconsistent usage of UNLOAD_PARTITIONS XMLA request handler");
        }
        OlapEngineUnloadPartitionsParams params = new OlapEngineUnloadPartitionsParams(request.getStatement(), schemaName, request.getDataSourceName(), request.getDataTableName(), request.isPartitionsAsRange(), request.getPartitions(), request.getWaitS(), request.getCancelS());
        OlapUnloadPartitionsHelper helper = new OlapUnloadPartitionsHelper(requestContext);
        OlapSchemaLifeCycleStatus status = helper.unloadPartitions(params);
        File schemaFactoryFile = context.getSchemaFactoryFile();
        if (schemaFactoryFile != null) {
            OlapEngineComponent olapEngine = requestContext.getOlapEngineComponent();
            OlapRuntimeContext rContext = requestContext.asRuntimeContext();
            info = olapEngine.getLoadedSchemaInformation(rContext, schemaFactoryFile);
        } else {
            info = null;
        }
        return XmlaUnloadPartitionsStatementCommandQueryHandler.createSchemaLifeCycleXmlaResponse(context, (XmlaExecuteQuery)request, status, info);
    }

    @Override
    protected XmlaResponse doExecuteOlapEngineRequestForPrepare(XmlaQueryContext context, XmlaUnloadPartitionsStatementCommandQuery request, OlapEngineRequestContext requestContext) {
        return XmlaUnloadPartitionsStatementCommandQueryHandler.createSchemaLifeCycleXmlaResponse(context, (XmlaExecuteQuery)request, null, null);
    }
}

