/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.server.iccube.server.message.execute;

import crazydev.common.babylon.CdBabylonService;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.mdx.ICompilationInfo;
import crazydev.iccube.olap.eval.cache.result.cache.OlapResultCache;
import crazydev.iccube.olap.eval.cache.result.cache.OlapResultCacheInfo;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreDeSerializer;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreReferenceKey;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreSerializer;
import crazydev.iccube.olap.eval.select.IExecuteStatementInstr;
import crazydev.iccube.olap.goodies.drillthrough.OlapDrillthroughInstr;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.pub.common.IOlapProtocol;
import crazydev.xmla.model.mddataset.IXmlaMDDataSet;
import crazydev.xmla.model.message.XmlaProperty;
import crazydev.xmla.model.message.execute.XmlaExecuteQuery;
import crazydev.xmla.model.message.execute.XmlaStatementCommandQuery;
import crazydev.xmla.model.proxy.XmlaInvocationTargetProxyException;
import crazydev.xmla.model.proxy.XmlaProxyException;
import crazydev.xmla.model.rowset.IXmlaRowSet;
import crazydev.xmla.model.types.XmlaFormat;
import crazydev.xmla.server.iccube.server.engine.XmlaQueryContext;
import crazydev.xmla.server.iccube.server.engine.XmlaResultStoreReferenceKey;
import crazydev.xmla.server.iccube.server.engine.XmlaResultStoreSerializer;
import crazydev.xmla.server.iccube.server.engine.XmlaServerProxy;
import crazydev.xmla.server.iccube.server.message.XmlaFault;
import crazydev.xmla.server.iccube.server.message.XmlaResponse;
import crazydev.xmla.server.iccube.server.message.common.XmlaOlapEngineQueryHandler;
import crazydev.xmla.server.iccube.server.message.execute.XmlaEmptyExecuteResponse;
import crazydev.xmla.server.iccube.server.message.execute.XmlaExecuteFromCacheMDDataSetResponse;
import crazydev.xmla.server.iccube.server.message.execute.XmlaExecuteFromCacheRowSetResponse;
import crazydev.xmla.server.iccube.server.message.execute.XmlaExecuteMDDataSetResponse;
import crazydev.xmla.server.iccube.server.message.execute.XmlaExecuteRowSetResponse;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class XmlaMdxStatementCommandQueryHandler
extends XmlaOlapEngineQueryHandler<XmlaStatementCommandQuery> {
    @Override
    protected XmlaResponse executeOlapEngineRequest(XmlaQueryContext context, XmlaStatementCommandQuery request, OlapEngineRequestContext requestContext) {
        this.logXmlaRequestInformation(request);
        List properties = request.getProperties();
        boolean forDrillthrough = false;
        ICompilationInfo compilation = context.getMdxCompilationInfo();
        if (compilation != null) {
            IExecuteStatementInstr instr = compilation.getInstr();
            forDrillthrough = instr instanceof OlapDrillthroughInstr;
        }
        XmlaFormat resultFormat = request.getActualFormat((XmlaFormat)(forDrillthrough ? XmlaFormat.Tabular : null));
        String statement = request.getStatement();
        requestContext.onMdxDetailAdded("MDX", request.getSchema(), statement);
        OlapResultCacheInfo resultCacheInfo = new OlapResultCacheInfo();
        XmlaResponse cachedResponse = this.executeOlapEngineRequestFromCache((OlapResultCacheInfo<XmlaResultStoreReferenceKey>)resultCacheInfo, context, requestContext, request, properties, resultFormat, statement);
        if (cachedResponse != null) {
            return cachedResponse;
        }
        return this.performMdxProcessing((OlapResultCacheInfo<XmlaResultStoreReferenceKey>)resultCacheInfo, context, requestContext, request, properties, resultFormat, statement);
    }

    private void logXmlaRequestInformation(XmlaStatementCommandQuery request) {
        if (!LOGGER.isDebugEnabled()) {
            return;
        }
        LOGGER.debug((Object)"XMLA : executing Execute");
        for (XmlaProperty property : request.getProperties()) {
            LOGGER.debug((Object)("   P : " + String.valueOf(property)));
        }
        LOGGER.debug((Object)(" MDX : " + request.getStatement()));
    }

    @Nullable
    private XmlaResponse executeOlapEngineRequestFromCache(OlapResultCacheInfo<XmlaResultStoreReferenceKey> resultCacheInfo, XmlaQueryContext context, OlapEngineRequestContext requestContext, XmlaStatementCommandQuery request, List<XmlaProperty> properties, XmlaFormat resultFormat, String statement) {
        ICompilationInfo compilationInfo = context.getMdxCompilationInfo();
        if (compilationInfo.hasResult()) {
            return null;
        }
        IExecuteStatementInstr statementInstr = compilationInfo.getInstr();
        if (statementInstr == null) {
            throw new RuntimeException("internal error: missing MDX evaluation instruction");
        }
        if (!statementInstr.isResultCacheEnabled()) {
            return null;
        }
        String schemaName = request.getSchema();
        if (schemaName == null) {
            throw new RuntimeException("internal error : missing schema");
        }
        OlapSchema schema = context.getSchema(statementInstr.getSchemaAccessLockMode(), properties, schemaName);
        if (schema == null) {
            return new XmlaFault(request.getSessionId(), (CdBabylonService)requestContext.getBabylonService(), "missing catalog [" + schemaName + "]");
        }
        OlapResultCache resultCache = requestContext.getOrCreateResultCache(IOlapProtocol.XMLA, schema);
        if (resultCache == null) {
            return null;
        }
        resultCacheInfo.setResultCache(resultCache);
        XmlaResultStoreReferenceKey resultKey = new XmlaResultStoreReferenceKey(resultFormat, context.getBehaviorsForResultStoreKey(), properties, statement);
        resultCacheInfo.setResultKey((OlapResultStoreReferenceKey)resultKey);
        OlapResultStoreDeSerializer cachedResult = resultCache.getResult(requestContext, (OlapResultStoreReferenceKey)resultKey);
        if (cachedResult == null) {
            return null;
        }
        requestContext.onDetailAdded("MDX (cache)", "Got result from cache");
        if (OlapLoggers.MDX_EVALUATION_RESULT_CACHE.isDebugEnabled()) {
            OlapLoggers.MDX_EVALUATION_RESULT_CACHE.debug((Object)"[result-cache] MDX result from cache");
        }
        if (resultFormat == XmlaFormat.Tabular) {
            return new XmlaExecuteFromCacheRowSetResponse(request.getSessionId(), (XmlaExecuteQuery)request, cachedResult);
        }
        return new XmlaExecuteFromCacheMDDataSetResponse(request.getSessionId(), (XmlaExecuteQuery)request, cachedResult);
    }

    private XmlaResponse performMdxProcessing(OlapResultCacheInfo<XmlaResultStoreReferenceKey> resultCacheInfo, XmlaQueryContext context, OlapEngineRequestContext requestContext, XmlaStatementCommandQuery request, List<XmlaProperty> properties, XmlaFormat resultFormat, String statement) {
        XmlaResponse response;
        if (resultFormat == XmlaFormat.Tabular) {
            response = this.performTabularMdxProcessing(context, request, properties, statement);
        } else if (resultFormat == XmlaFormat.Multidimensional) {
            response = this.performMultiDimensionalMdxProcessing(context, request, properties, statement);
        } else {
            throw new RuntimeException("internal error : unexpected XMLA response result format [" + String.valueOf(resultFormat) + "]");
        }
        if (resultCacheInfo.isCacheWriteEnabled()) {
            XmlaResultStoreReferenceKey resultKey = (XmlaResultStoreReferenceKey)resultCacheInfo.getResultKey();
            XmlaResultStoreSerializer resultSerializer = new XmlaResultStoreSerializer(context.getXmlaCaller(), response);
            OlapResultCache resultCache = resultCacheInfo.getResultCache();
            if (resultCache.addResult(requestContext, (OlapResultStoreReferenceKey)resultKey, (OlapResultStoreSerializer)resultSerializer)) {
                requestContext.onDetailAdded("MDX (cache)", "Result stored into cache");
                if (OlapLoggers.MDX_EVALUATION_RESULT_CACHE.isDebugEnabled()) {
                    OlapLoggers.MDX_EVALUATION_RESULT_CACHE.debug((Object)"[result-cache] MDX result stored into cache");
                }
            }
        }
        return response;
    }

    private XmlaResponse performMultiDimensionalMdxProcessing(XmlaQueryContext context, XmlaStatementCommandQuery request, List<XmlaProperty> properties, String statement) {
        try {
            XmlaServerProxy xmlaServerEngine = context.getXmlaEngine();
            IXmlaMDDataSet result = xmlaServerEngine.executeMDXStatement(context, statement, properties);
            if (result.isBlank()) {
                return new XmlaEmptyExecuteResponse(request.getSessionId(), (XmlaExecuteQuery)request);
            }
            return new XmlaExecuteMDDataSetResponse(request.getSessionId(), (XmlaExecuteQuery)request, result);
        }
        catch (XmlaProxyException ex) {
            throw new XmlaInvocationTargetProxyException((Exception)((Object)ex));
        }
    }

    private XmlaResponse performTabularMdxProcessing(XmlaQueryContext context, XmlaStatementCommandQuery request, List<XmlaProperty> properties, String statement) {
        try {
            XmlaServerProxy xmlaServerEngine = context.getXmlaEngine();
            IXmlaRowSet result = xmlaServerEngine.executeMDXStatementAsRowSet(context, statement, properties);
            if (result.isBlank()) {
                return new XmlaEmptyExecuteResponse(request.getSessionId(), (XmlaExecuteQuery)request);
            }
            return new XmlaExecuteRowSetResponse(request.getSessionId(), (XmlaExecuteQuery)request, result);
        }
        catch (XmlaProxyException ex) {
            throw new XmlaInvocationTargetProxyException((Exception)((Object)ex));
        }
    }

    @Override
    protected XmlaResponse executeOlapEngineRequestForPrepare(XmlaQueryContext context, XmlaStatementCommandQuery request, OlapEngineRequestContext requestContext) {
        return this.executeOlapEngineRequest(context, request, requestContext);
    }
}

