/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.server.iccube.server.message.execute;

import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationApplicationFeatureException;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationException;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.command.builtin.OlapEngineLoadPartitionsParams;
import crazydev.iccube.olap.component.command.builtin.OlapEngineLoadTablePartitionsParams;
import crazydev.iccube.olap.component.command.builtin.OlapLoadPartitionsHelper;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaLifeCycleStatus;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.schema.OlapSchemaInformation;
import crazydev.xmla.model.message.execute.XmlaExecuteQuery;
import crazydev.xmla.model.message.execute.XmlaLoadPartitionsStatementCommandQuery;
import crazydev.xmla.model.message.execute.XmlaLoadTablePartitionsParams;
import crazydev.xmla.server.iccube.server.engine.XmlaQueryContext;
import crazydev.xmla.server.iccube.server.message.XmlaResponse;
import crazydev.xmla.server.iccube.server.message.common.XmlaManagementApiQueryHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class XmlaLoadPartitionsStatementCommandQueryHandler
extends XmlaManagementApiQueryHandler<XmlaLoadPartitionsStatementCommandQuery> {
    @Override
    protected void assertRequestAuthorized(XmlaQueryContext context, OlapRoleApplicationPermissions permissions, XmlaLoadPartitionsStatementCommandQuery request) throws OlapRoleAuthorizationException {
        super.assertRequestAuthorized(context, permissions, request);
        if (!context.isFactsPartitioningLicensed() || !context.isTablePartitioningLicensed()) {
            throw new OlapRoleAuthorizationApplicationFeatureException("app.server", "app.server.managementApi.partitions");
        }
    }

    @Override
    protected XmlaResponse doExecuteOlapEngineRequest(XmlaQueryContext context, XmlaLoadPartitionsStatementCommandQuery request, OlapEngineRequestContext requestContext) {
        OlapSchemaInformation info;
        String schemaName = request.getSchema();
        if (schemaName == null) {
            throw new RuntimeException("internal error: inconsistent usage of LOAD_PARTITIONS XMLA request handler");
        }
        List partitions = request.getPartitions();
        ArrayList<OlapEngineLoadTablePartitionsParams> ePartitions = new ArrayList<OlapEngineLoadTablePartitionsParams>();
        for (XmlaLoadTablePartitionsParams partition : partitions) {
            ePartitions.add(new OlapEngineLoadTablePartitionsParams(partition.tableName, partition.partitionsAsRange, partition.partitions));
        }
        OlapEngineLoadPartitionsParams params = new OlapEngineLoadPartitionsParams(request.getStatement(), schemaName, request.getDataSourceName(), ePartitions, request.getWaitS(), request.getCancelS(), request.isContinueBackupOnError());
        OlapLoadPartitionsHelper helper = new OlapLoadPartitionsHelper(requestContext);
        OlapSchemaLifeCycleStatus status = helper.loadPartitions(params);
        File schemaFactoryFile = context.getSchemaFactoryFile();
        if (schemaFactoryFile != null) {
            OlapEngineComponent olapEngine = requestContext.getOlapEngineComponent();
            OlapRuntimeContext rContext = requestContext.asRuntimeContext();
            info = olapEngine.getLoadedSchemaInformation(rContext, schemaFactoryFile);
        } else {
            info = null;
        }
        return XmlaLoadPartitionsStatementCommandQueryHandler.createSchemaLifeCycleXmlaResponse(context, (XmlaExecuteQuery)request, status, info);
    }

    @Override
    protected XmlaResponse doExecuteOlapEngineRequestForPrepare(XmlaQueryContext context, XmlaLoadPartitionsStatementCommandQuery request, OlapEngineRequestContext requestContext) {
        return XmlaLoadPartitionsStatementCommandQueryHandler.createSchemaLifeCycleXmlaResponse(context, (XmlaExecuteQuery)request, null, null);
    }
}

