/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.server.iccube.server.message.execute;

import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.command.builtin.IOlapEngineLoadSchemaParams;
import crazydev.iccube.olap.component.command.builtin.OlapEngineLoadSchemaParams;
import crazydev.iccube.olap.component.command.builtin.OlapEngineOfflineMode;
import crazydev.iccube.olap.component.command.builtin.OlapLoadSchemaHelper;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaLifeCycleStatus;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.schema.OlapSchemaInformation;
import crazydev.xmla.model.message.execute.XmlaExecuteQuery;
import crazydev.xmla.model.message.execute.XmlaFullLoadSchemaStatementCommandQuery;
import crazydev.xmla.model.message.execute.XmlaSchemaManagementStatementCommandQuery;
import crazydev.xmla.server.iccube.server.engine.XmlaQueryContext;
import crazydev.xmla.server.iccube.server.message.XmlaResponse;
import crazydev.xmla.server.iccube.server.message.common.XmlaManagementApiQueryHandler;
import java.io.File;

public class XmlaFullLoadSchemaStatementCommandQueryHandler
extends XmlaManagementApiQueryHandler<XmlaFullLoadSchemaStatementCommandQuery> {
    @Override
    protected XmlaResponse doExecuteOlapEngineRequest(XmlaQueryContext context, XmlaFullLoadSchemaStatementCommandQuery request, OlapEngineRequestContext requestContext) {
        OlapEngineLoadSchemaParams params;
        File schemaFactoryFile = context.getSchemaFactoryFile();
        if (schemaFactoryFile == null) {
            throw new RuntimeException("internal error : missing schema definition file");
        }
        boolean forceBackupOn = request.isForceBackupOn();
        XmlaSchemaManagementStatementCommandQuery.OfflineMode offlineMode = request.getOfflineMode();
        String offlineSnapshot = request.getOfflineSnapshot();
        if (offlineMode == null || offlineMode == XmlaSchemaManagementStatementCommandQuery.OfflineMode.OFF) {
            params = new OlapEngineLoadSchemaParams(schemaFactoryFile, true, request.getWaitS(), request.getCancelS(), OlapEngineOfflineMode.OFF, null, forceBackupOn);
        } else if (offlineMode == XmlaSchemaManagementStatementCommandQuery.OfflineMode.WRITE) {
            params = new OlapEngineLoadSchemaParams(schemaFactoryFile, true, request.getWaitS(), request.getCancelS(), OlapEngineOfflineMode.WRITE, null, false);
        } else if (offlineMode == XmlaSchemaManagementStatementCommandQuery.OfflineMode.WRITE_ZIP) {
            params = new OlapEngineLoadSchemaParams(schemaFactoryFile, true, request.getWaitS(), request.getCancelS(), OlapEngineOfflineMode.WRITE_ZIP, null, false);
        } else if (offlineMode == XmlaSchemaManagementStatementCommandQuery.OfflineMode.WRITE_ONLY) {
            params = new OlapEngineLoadSchemaParams(schemaFactoryFile, true, request.getWaitS(), request.getCancelS(), OlapEngineOfflineMode.WRITE_ONLY, null, false);
        } else if (offlineMode == XmlaSchemaManagementStatementCommandQuery.OfflineMode.READ) {
            params = new OlapEngineLoadSchemaParams(schemaFactoryFile, true, request.getWaitS(), request.getCancelS(), OlapEngineOfflineMode.READ, offlineSnapshot, forceBackupOn);
        } else {
            throw new RuntimeException("internal error : unsupported offline mode [" + String.valueOf(offlineMode) + "]");
        }
        OlapLoadSchemaHelper helper = new OlapLoadSchemaHelper(requestContext);
        OlapSchemaLifeCycleStatus status = helper.loadSchema((IOlapEngineLoadSchemaParams)params);
        OlapEngineComponent olapEngine = requestContext.getOlapEngineComponent();
        OlapRuntimeContext rContext = requestContext.asRuntimeContext();
        OlapSchemaInformation info = olapEngine.getLoadedSchemaInformation(rContext, schemaFactoryFile);
        return XmlaFullLoadSchemaStatementCommandQueryHandler.createSchemaLifeCycleXmlaResponse(context, (XmlaExecuteQuery)request, status, info);
    }

    @Override
    protected XmlaResponse doExecuteOlapEngineRequestForPrepare(XmlaQueryContext context, XmlaFullLoadSchemaStatementCommandQuery request, OlapEngineRequestContext requestContext) {
        return XmlaFullLoadSchemaStatementCommandQueryHandler.createSchemaLifeCycleXmlaResponse(context, (XmlaExecuteQuery)request, null, null);
    }
}

