/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.server.iccube.server.message.execute;

import crazydev.common.xmla.CdXmlaCaller;
import crazydev.xmla.model.message.XmlaSerializer;
import crazydev.xmla.model.message.execute.XmlaExecuteQuery;
import crazydev.xmla.model.rowset.IXmlaRowSet;
import crazydev.xmla.model.rowset.IXmlaRowSetDataRow;
import crazydev.xmla.server.iccube.mddataset.XmlaDataSetSerializer;
import crazydev.xmla.server.iccube.server.message.common.XmlaMdxResponse;
import crazydev.xmla.server.iccube.server.message.execute.rsc.XmlaResource;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.xml.serialize.OutputFormat;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XmlaExecuteRowSetResponse
extends XmlaMdxResponse<XmlaExecuteQuery> {
    private final IXmlaRowSet result;
    private static final String SCHEMA = XmlaResource.getResource("MD_ROWSET.xml", true);

    public XmlaExecuteRowSetResponse(@Nullable String sessionId, XmlaExecuteQuery payload, IXmlaRowSet result) {
        super(sessionId, payload);
        this.result = result;
    }

    @Override
    @Nullable
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    protected String getReturnType() {
        return "urn:schemas-microsoft-com:xml-analysis:rowset";
    }

    @Override
    protected String getXMLRequest() {
        return "ExecuteResponse";
    }

    @Override
    protected void doEmitXmlaSchema(XmlaSerializer serializer) throws SAXException, IOException {
        String sequenceContent = this.doEmitXmlaSchemaSequence(serializer.getXmlaCaller());
        String schema = SCHEMA.replace("[Sequence]", sequenceContent);
        serializer.addRawXml(schema);
    }

    private String doEmitXmlaSchemaSequence(CdXmlaCaller caller) throws SAXException {
        StringWriter out = new StringWriter();
        PrintWriter writer = new PrintWriter(out);
        OutputFormat format = this.createSerializerOutputFormat(true);
        XmlaSerializer serializer = this.createSerializer(caller, null, writer, format);
        serializer.startDocument();
        IXmlaRowSetDataRow titleRow = this.result.getTitle();
        for (int idx = 0; idx < titleRow.size(); ++idx) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute(null, null, "sql:field", "string", titleRow.get(idx).asString());
            attrs.addAttribute(null, null, "name", "string", titleRow.getXmlElementName(idx));
            attrs.addAttribute(null, null, "minOccurs", "string", "0");
            serializer.startElement(null, null, "xsd:element", (Attributes)attrs);
            serializer.endElement(null, null, "xsd:element");
        }
        serializer.endDocument();
        String sequence = out.getBuffer().toString();
        return sequence;
    }

    @Override
    protected void doEmitXmlaData(XmlaSerializer serializer) throws SAXException {
        if (this.result == null) {
            return;
        }
        new XmlaDataSetSerializer().streamRowSet(serializer, this.result);
    }
}

