/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.server.iccube.server.message.execute;

import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.xmla.model.message.XmlaProperty;
import crazydev.xmla.model.message.execute.XmlaDmvStatementCommandQuery;
import crazydev.xmla.model.message.execute.XmlaStatementCommandQuery;
import crazydev.xmla.server.iccube.server.engine.XmlaQueryContext;
import crazydev.xmla.server.iccube.server.message.XmlaResponse;
import crazydev.xmla.server.iccube.server.message.common.XmlaOlapEngineQueryHandler;
import crazydev.xmla.server.iccube.server.message.discover.XmlaDiscoverResponse;
import crazydev.xmla.server.iccube.server.message.execute.dmv.XmlaDmvStatement;
import net.sf.jsqlparser.JSQLParserException;

public class XmlaDmvStatementCommandQueryHandler
extends XmlaOlapEngineQueryHandler<XmlaDmvStatementCommandQuery> {
    @Override
    protected XmlaResponse executeOlapEngineRequest(XmlaQueryContext context, XmlaDmvStatementCommandQuery request, OlapEngineRequestContext requestContext) {
        this.logXmlaRequestInformation((XmlaStatementCommandQuery)request);
        String statement = request.getStatement();
        requestContext.onMdxDetailAdded("XMLA DMV", request.getSchema(), statement);
        OlapLoggers.XMLA_REQUEST.info((Object)("DMV statement : " + statement));
        try {
            XmlaDmvStatement dmv = XmlaDmvStatement.fromRequest(request);
            XmlaDiscoverResponse response = dmv.execute(context);
            return response;
        }
        catch (JSQLParserException ex) {
            OlapLoggers.XMLA_REQUEST.error((Object)("XMLA DMV statement error : " + statement), (Throwable)ex);
            throw new RuntimeException(ex.getMessage());
        }
    }

    private void logXmlaRequestInformation(XmlaStatementCommandQuery request) {
        if (!LOGGER.isDebugEnabled()) {
            return;
        }
        LOGGER.debug((Object)"XMLA : executing Execute");
        for (XmlaProperty property : request.getProperties()) {
            LOGGER.debug((Object)("   P : " + String.valueOf(property)));
        }
        LOGGER.debug((Object)(" DMV : " + request.getStatement()));
    }

    @Override
    protected XmlaResponse executeOlapEngineRequestForPrepare(XmlaQueryContext context, XmlaDmvStatementCommandQuery request, OlapEngineRequestContext requestContext) {
        throw new RuntimeException("internal error : execute DMV prepare not implemented");
    }
}

