/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.server.iccube.server.message.execute;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.utils.CdIoUtils;
import crazydev.common.xml.CdXmlUtils;
import crazydev.iccube.authorization.definition.role.OlapRoleDefinitions;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionError;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionErrorCode;
import crazydev.iccube.contextual.OlapContextualBigException;
import crazydev.iccube.contextual.OlapContextualError;
import crazydev.iccube.directories.OlapDirectoriesResolved;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.authorization.IOlapPermissionsService;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import crazydev.xmla.model.message.execute.XmlaApplyPermissionsStatementCommandQuery;
import crazydev.xmla.model.message.execute.XmlaExecuteQuery;
import crazydev.xmla.model.rowset.IXmlaRowSet;
import crazydev.xmla.model.types.XmlaFormat;
import crazydev.xmla.server.iccube.server.engine.XmlaQueryContext;
import crazydev.xmla.server.iccube.server.message.XmlaResponse;
import crazydev.xmla.server.iccube.server.message.common.XmlaErrorsMDDataSet;
import crazydev.xmla.server.iccube.server.message.common.XmlaErrorsRowSet;
import crazydev.xmla.server.iccube.server.message.common.XmlaManagementApiQueryHandler;
import crazydev.xmla.server.iccube.server.message.execute.XmlaExecuteMDDataSetResponse;
import crazydev.xmla.server.iccube.server.message.execute.XmlaExecuteRowSetResponse;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class XmlaApplyPermissionsStatementCommandQueryHandler
extends XmlaManagementApiQueryHandler<XmlaApplyPermissionsStatementCommandQuery> {
    @Override
    protected XmlaResponse doExecuteOlapEngineRequest(XmlaQueryContext context, XmlaApplyPermissionsStatementCommandQuery request, OlapEngineRequestContext requestContext) {
        if (OlapLoggers.AUTHORIZATION.isInfoEnabled()) {
            OlapLoggers.AUTHORIZATION.info((Object)"[permissions] applying permissions : unmarshalling definitions");
        }
        OlapRuntimeContext runtimeContext = requestContext.asRuntimeContext();
        OlapDirectoriesResolved directories = runtimeContext.getDirectoriesResolved();
        File roles = directories.getRolesDirectory();
        File definitions = new File(roles, "icCubeRoles.icc-roles");
        OlapRoleDefinitions roleDefinitions = null;
        try (InputStream in = CdIoUtils.createInputStreamBOM((File)definitions, (String)"UTF-8");
             BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));){
            roleDefinitions = (OlapRoleDefinitions)CdXmlUtils.unmarshall((File)definitions, (Reader)reader, (Class[])new Class[]{OlapRoleDefinitions.class});
        }
        catch (Exception ex) {
            OlapLoggers.AUTHORIZATION.error((Object)"[permissions] could not unmarshall role definitions", (Throwable)ex);
            return this.onError(context, request, ex);
        }
        if (OlapLoggers.AUTHORIZATION.isInfoEnabled()) {
            OlapLoggers.AUTHORIZATION.info((Object)"[permissions] applying unmarshalled permissions");
        }
        try {
            IOlapPermissionsService service = context.getRolePermissionsService();
            if (!service.applyPermissions(requestContext, roleDefinitions)) {
                OlapLoggers.AUTHORIZATION.info((Object)"[permissions] applying permissions error(s)");
                return this.onError(context, request);
            }
            return this.onSuccess(context, request);
        }
        catch (Exception ex) {
            OlapLoggers.AUTHORIZATION.error((Object)"[permissions] could not apply role definitions", (Throwable)ex);
            return this.onError(context, request, ex);
        }
    }

    @Override
    protected XmlaResponse doExecuteOlapEngineRequestForPrepare(XmlaQueryContext context, XmlaApplyPermissionsStatementCommandQuery request, OlapEngineRequestContext requestContext) {
        return this.onSuccess(context, request);
    }

    private XmlaResponse onError(XmlaQueryContext context, XmlaApplyPermissionsStatementCommandQuery request) {
        ArrayList<OlapContextualError> errors = new ArrayList<OlapContextualError>();
        errors.add((OlapContextualError)new OlapRoleDefinitionError(OlapRoleDefinitionErrorCode.APPLICATIONS_PERMISSIONS_SETUP_ERROR, new Serializable[0]));
        return this.onError(context, request, errors);
    }

    private XmlaResponse onError(XmlaQueryContext context, XmlaApplyPermissionsStatementCommandQuery request, Exception ex) {
        ArrayList<OlapContextualError> errors = new ArrayList<OlapContextualError>();
        errors.add((OlapContextualError)new OlapRoleDefinitionError(OlapRoleDefinitionErrorCode.APPLICATIONS_PERMISSIONS_SETUP_ERROR, new Serializable[0]));
        if (ex instanceof OlapContextualBigException) {
            errors.addAll(((OlapContextualBigException)ex).getErrors());
        } else {
            errors.add((OlapContextualError)new OlapRoleDefinitionError(OlapRoleDefinitionErrorCode.UNEXPECTED_ERROR, new Serializable[]{ex.toString()}));
        }
        return this.onError(context, request, errors);
    }

    private XmlaResponse onError(XmlaQueryContext context, XmlaApplyPermissionsStatementCommandQuery request, List<OlapContextualError> errors) {
        OlapEngineRequestContext engineContext = context.getOlapEngineRequestContext();
        if (!errors.isEmpty()) {
            errors.add(0, (OlapContextualError)new OlapRoleDefinitionError(OlapRoleDefinitionErrorCode.UNEXPECTED_ERROR, new Serializable[]{"[request-uuid] " + context.getOlapEngineRequestContext().getRequestClientUUID()}));
        }
        ArrayList<String> errors_ = new ArrayList<String>();
        for (OlapContextualError olapContextualError : errors) {
            errors_.add(olapContextualError.asFullMessage((CdBabylonService)engineContext.getBabylonService()));
        }
        OlapLoggers.AUTHORIZATION.error((Object)"[permissions] error(s)");
        for (String string : errors_) {
            OlapLoggers.AUTHORIZATION.error((Object)("- " + string));
        }
        IcCubeRequestStatusManager statusManager = context.getRequestStatusManager();
        statusManager.onRequestErrors(engineContext.getRequestClientUUID(), errors);
        return this.reply(context, request, errors_);
    }

    private XmlaResponse onSuccess(XmlaQueryContext context, XmlaApplyPermissionsStatementCommandQuery request) {
        return this.reply(context, request, Collections.emptyList());
    }

    private XmlaResponse reply(XmlaQueryContext context, XmlaApplyPermissionsStatementCommandQuery request, List<String> errors) {
        if (request.getActualFormat() == XmlaFormat.Multidimensional) {
            XmlaErrorsMDDataSet xmlaResult = new XmlaErrorsMDDataSet(errors);
            return new XmlaExecuteMDDataSetResponse(request.getSessionId(), (XmlaExecuteQuery)request, xmlaResult);
        }
        XmlaErrorsRowSet xmlaResult = new XmlaErrorsRowSet(errors);
        return new XmlaExecuteRowSetResponse(request.getSessionId(), (XmlaExecuteQuery)request, (IXmlaRowSet)xmlaResult);
    }
}

