/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.server.iccube.server.message.discover;

import crazydev.common.collection.CdCollections;
import crazydev.common.xmla.CdXmlaCaller;
import crazydev.xmla.model.discover.IXmlaDiscover;
import crazydev.xmla.model.message.XmlaSerializer;
import crazydev.xmla.model.message.discover.XmlaDiscoverQuery;
import crazydev.xmla.server.iccube.rowset.IXmlaDiscoverRowColumn;
import crazydev.xmla.server.iccube.rowset.XmlaDiscoverRowSet;
import crazydev.xmla.server.iccube.server.message.common.XmlaMdxResponse;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XmlaDiscoverResponse
extends XmlaMdxResponse<XmlaDiscoverQuery> {
    private final XmlaDiscoverRowSet rowSetDef;
    private final List<? extends IXmlaDiscover> items;
    private final boolean dmv;

    public XmlaDiscoverResponse(@Nullable String sessionId, XmlaDiscoverQuery payload, XmlaDiscoverRowSet rowSetDef, List<? extends IXmlaDiscover> items) {
        super(sessionId, payload);
        this.rowSetDef = rowSetDef;
        this.items = items;
        this.dmv = false;
    }

    public XmlaDiscoverResponse(boolean dmv, @Nullable String sessionId, XmlaDiscoverQuery payload, XmlaDiscoverRowSet rowSetDef, List<? extends IXmlaDiscover> items) {
        super(sessionId, payload);
        this.rowSetDef = rowSetDef;
        this.items = items;
        this.dmv = true;
    }

    @Override
    @Nullable
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    protected String getReturnType() {
        return "urn:schemas-microsoft-com:xml-analysis:rowset";
    }

    public List<? extends IXmlaDiscover> getItems() {
        return this.items;
    }

    @Override
    protected String getXMLRequest() {
        return !this.dmv ? "DiscoverResponse" : "ExecuteResponse";
    }

    @Override
    protected void emitSoapEnvelopeHeader(XmlaSerializer serializer) throws SAXException {
        CdXmlaCaller caller = serializer.getXmlaCaller();
        if (CdXmlaCaller.ic3.equals((Object)caller)) {
            super.emitSoapEnvelopeHeader(serializer);
        }
    }

    @Override
    protected void doEmitRegularSoapEnvelopeBodyXMLNS(AttributesImpl attrs) {
        if ("DISCOVER_XML_METADATA".equals(this.rowSetDef.getXmlaClazz().name())) {
            attrs.addAttribute(null, null, "xmlns:ddl300", "string", "http://schemas.microsoft.com/analysisservices/2011/engine/300");
            attrs.addAttribute(null, null, "xmlns:ddl400", "string", "http://schemas.microsoft.com/analysisservices/2012/engine/400");
            attrs.addAttribute(null, null, "xmlns:ddl600", "string", "http://schemas.microsoft.com/analysisservices/2013/engine/600");
            attrs.addAttribute(null, null, "xmlns:ddl900", "string", "http://schemas.microsoft.com/analysisservices/2019/engine/900");
        }
    }

    @Override
    protected void doEmitXmlaSchema(XmlaSerializer serializer) throws SAXException {
        AttributesImpl schemaAttrs = new AttributesImpl();
        schemaAttrs.addAttribute(null, null, "xmlns:sql", "string", "urn:schemas-microsoft-com:xml-sql");
        schemaAttrs.addAttribute(null, null, "targetNamespace", "string", "urn:schemas-microsoft-com:xml-analysis:rowset");
        schemaAttrs.addAttribute(null, null, "elementFormDefault", "string", "qualified");
        serializer.startElement(null, null, "xsd:schema", (Attributes)schemaAttrs);
        AttributesImpl elementAttrs = new AttributesImpl();
        elementAttrs.addAttribute(null, null, "name", "string", "root");
        serializer.startElement(null, null, "xsd:element", (Attributes)elementAttrs);
        serializer.startElement(null, null, "xsd:complexType", null);
        AttributesImpl seqAttrs = new AttributesImpl();
        seqAttrs.addAttribute(null, null, "minOccurs", "string", "0");
        seqAttrs.addAttribute(null, null, "maxOccurs", "string", "unbounded");
        serializer.startElement(null, null, "xsd:sequence", (Attributes)seqAttrs);
        AttributesImpl elemAttrs = new AttributesImpl();
        elemAttrs.addAttribute(null, null, "name", "string", "row");
        elemAttrs.addAttribute(null, null, "type", "string", "row");
        serializer.startElement(null, null, "xsd:element", (Attributes)elemAttrs);
        serializer.endElement(null, null, "xsd:element");
        serializer.endElement(null, null, "xsd:sequence");
        serializer.endElement(null, null, "xsd:complexType");
        serializer.endElement(null, null, "xsd:element");
        this.emitXmlUuid((ContentHandler)serializer);
        AttributesImpl docAttrs = new AttributesImpl();
        docAttrs.addAttribute(null, null, "name", "string", "xmlDocument");
        serializer.startElement(null, null, "xsd:complexType", (Attributes)docAttrs);
        serializer.startElement(null, null, "xsd:sequence", null);
        serializer.startElement(null, null, "xsd:any", null);
        serializer.endElement(null, null, "xsd:any");
        serializer.endElement(null, null, "xsd:sequence");
        serializer.endElement(null, null, "xsd:complexType");
        this.emitRowSchema(serializer);
        serializer.endElement(null, null, "xsd:schema");
    }

    private void emitXmlUuid(ContentHandler serializer) throws SAXException {
        AttributesImpl simpleTypeAttrs = new AttributesImpl();
        simpleTypeAttrs.addAttribute(null, null, "name", "string", "uuid");
        serializer.startElement(null, null, "xsd:simpleType", simpleTypeAttrs);
        AttributesImpl restrictionAttrs = new AttributesImpl();
        restrictionAttrs.addAttribute(null, null, "base", "string", "xsd:string");
        serializer.startElement(null, null, "xsd:restriction", restrictionAttrs);
        AttributesImpl patternAttrs = new AttributesImpl();
        patternAttrs.addAttribute(null, null, "value", "string", "[0-9a-zA-Z]{8}-[0-9a-zA-Z]{4}-[0-9a-zA-Z]{4}-[0-9a-zA-Z]{4}-[0-9a-zA-Z]{12}");
        serializer.startElement(null, null, "xsd:pattern", patternAttrs);
        serializer.endElement(null, null, "xsd:pattern");
        serializer.endElement(null, null, "xsd:restriction");
        serializer.endElement(null, null, "xsd:simpleType");
    }

    private void emitRowSchema(XmlaSerializer serializer) throws SAXException {
        AttributesImpl complexTypeAttrs = new AttributesImpl();
        complexTypeAttrs.addAttribute(null, null, "name", "string", "row");
        IXmlaDiscover firstItem = (IXmlaDiscover)CdCollections.first(this.items);
        serializer.startElement(null, null, "xsd:complexType", (Attributes)complexTypeAttrs);
        serializer.startElement(null, null, "xsd:sequence", null);
        for (IXmlaDiscoverRowColumn iXmlaDiscoverRowColumn : this.rowSetDef.getList()) {
            iXmlaDiscoverRowColumn.emitXmlSchema(serializer, firstItem);
        }
        serializer.endElement(null, null, "xsd:sequence");
        serializer.endElement(null, null, "xsd:complexType");
    }

    @Override
    protected void doEmitXmlaData(XmlaSerializer serializer) throws SAXException, IOException {
        for (IXmlaDiscover iXmlaDiscover : this.items) {
            serializer.startElement(null, null, "row", null);
            for (IXmlaDiscoverRowColumn iXmlaDiscoverRowColumn : this.rowSetDef.getList()) {
                iXmlaDiscoverRowColumn.emitData(serializer, iXmlaDiscover);
            }
            serializer.endElement(null, null, "row");
        }
    }
}

