/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.server.iccube.server.message.discover;

import crazydev.common.collection.CdArrays;
import crazydev.common.xmla.CdXmlaCaller;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.xmla.model.discover.IXmlaDiscover;
import crazydev.xmla.model.message.XmlaProperty;
import crazydev.xmla.model.message.XmlaRestriction;
import crazydev.xmla.model.message.discover.XmlaDiscoverQuery;
import crazydev.xmla.server.iccube.rowset.IXmlaDiscoverRowColumn;
import crazydev.xmla.server.iccube.rowset.XmlaDiscoverRowSet;
import crazydev.xmla.server.iccube.rowset.XmlaDiscoverRowSetFactory;
import crazydev.xmla.server.iccube.server.engine.XmlaQueryContext;
import crazydev.xmla.server.iccube.server.message.XmlaResponse;
import crazydev.xmla.server.iccube.server.message.common.XmlaOlapEngineQueryHandler;
import crazydev.xmla.server.iccube.server.message.discover.XmlaDiscoverRequestMethodCallers;
import crazydev.xmla.server.iccube.server.message.discover.XmlaDiscoverResponse;
import java.util.ArrayList;
import java.util.List;

public class XmlaDiscoverQueryHandler
extends XmlaOlapEngineQueryHandler<XmlaDiscoverQuery> {
    private static List<IXmlaDiscover> discover(XmlaQueryContext context, XmlaDiscoverQuery request, XmlaDiscoverRowSet rowSetDef) {
        List<? extends IXmlaDiscover> rowSetData = XmlaDiscoverRequestMethodCallers.getDiscoverAnswer(context, request);
        List<IXmlaDiscover> filtered = XmlaDiscoverQueryHandler.filter(request, rowSetDef, rowSetData);
        return filtered;
    }

    private static List<IXmlaDiscover> filter(XmlaDiscoverQuery discover, XmlaDiscoverRowSet rowSetDef, List<? extends IXmlaDiscover> rowSetData) {
        ArrayList<IXmlaDiscover> filtered = new ArrayList<IXmlaDiscover>();
        Object[] notFiltered = new String[]{"DISCOVER_PROPERTIES", "MDSCHEMA_CUBES", "MDSCHEMA_PROPERTIES", "MDSCHEMA_MEMBERS", "MDSCHEMA_ACTIONS"};
        if (CdArrays.contains((Object)discover.getRequestType(), (Object[])notFiltered)) {
            filtered.addAll(rowSetData);
        } else {
            XmlaDiscoverQueryHandler.applyFilter(discover, rowSetDef, rowSetData, filtered);
        }
        return filtered;
    }

    private static void applyFilter(XmlaDiscoverQuery discover, XmlaDiscoverRowSet rowSetDef, List<? extends IXmlaDiscover> rowSetData, List<IXmlaDiscover> filtered) {
        List restrictions = discover.getRestrictions();
        if (!restrictions.isEmpty()) {
            for (IXmlaDiscover iXmlaDiscover : rowSetData) {
                boolean add = true;
                for (XmlaRestriction restriction : restrictions) {
                    IXmlaDiscoverRowColumn col = rowSetDef.getColumn(restriction);
                    String restrictionValue = restriction.getValue();
                    if (col == null || !col.restrictionMatches(iXmlaDiscover, restrictionValue)) continue;
                    add = false;
                    break;
                }
                if (!add) continue;
                filtered.add(iXmlaDiscover);
            }
        } else {
            filtered.addAll(rowSetData);
        }
    }

    protected XmlaDiscoverResponse executeOlapEngineRequest(XmlaQueryContext context, XmlaDiscoverQuery request, OlapEngineRequestContext requestContext) {
        CdXmlaCaller caller = context.getXmlaCaller();
        String requestType = request.getRequestType();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("XMLA : executing Discover [" + requestType + "]"));
            for (XmlaProperty property : request.getProperties()) {
                LOGGER.debug((Object)("   P : " + String.valueOf(property)));
            }
            for (XmlaRestriction restriction : request.getRestrictions()) {
                LOGGER.debug((Object)("   R : " + String.valueOf(restriction)));
            }
        }
        XmlaDiscoverRowSet rowSetDef = XmlaDiscoverRowSetFactory.getExisting(request.getRequestType());
        List<IXmlaDiscover> filtered = XmlaDiscoverQueryHandler.discover(context, request, rowSetDef);
        return new XmlaDiscoverResponse(request.getSessionId(), request, rowSetDef, filtered);
    }

    @Override
    protected XmlaResponse executeOlapEngineRequestForPrepare(XmlaQueryContext context, XmlaDiscoverQuery request, OlapEngineRequestContext requestContext) {
        XmlaDiscoverRowSet rowSetDef = XmlaDiscoverRowSetFactory.getExisting(request.getRequestType());
        return new XmlaDiscoverResponse(request.getSessionId(), request, rowSetDef, new ArrayList());
    }
}

