/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.server.iccube.server.message.common;

import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationApplicationFeatureException;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationException;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaLifeCycleStatus;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaLoadStatus;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.schema.OlapSchemaInformation;
import crazydev.xmla.model.mddataset.IXmlaMDDataSet;
import crazydev.xmla.model.message.execute.XmlaExecuteQuery;
import crazydev.xmla.model.rowset.IXmlaRowSet;
import crazydev.xmla.model.types.XmlaFormat;
import crazydev.xmla.server.iccube.server.engine.XmlaQueryContext;
import crazydev.xmla.server.iccube.server.message.XmlaResponse;
import crazydev.xmla.server.iccube.server.message.common.XmlaMdxResponse;
import crazydev.xmla.server.iccube.server.message.common.XmlaOlapEngineQueryHandler;
import crazydev.xmla.server.iccube.server.message.common.XmlaSchemaManagementMDDataSet;
import crazydev.xmla.server.iccube.server.message.common.XmlaSchemaManagementRowSet;
import crazydev.xmla.server.iccube.server.message.execute.XmlaExecuteSchemaLifeCycleRowSetResponse;
import crazydev.xmla.server.iccube.server.message.execute.XmlaExecuteSchemaLifeSchemaMDDataSetResponse;
import org.jetbrains.annotations.Nullable;

public abstract class XmlaManagementApiQueryHandler<T extends XmlaExecuteQuery>
extends XmlaOlapEngineQueryHandler<T> {
    @Override
    protected void assertRequestAuthorized(XmlaQueryContext context, OlapRoleApplicationPermissions permissions, T request) throws OlapRoleAuthorizationException {
        permissions.assertMonitoringSchemasEnabled();
        if (!context.isManagementApiAvailable()) {
            throw new OlapRoleAuthorizationApplicationFeatureException("app.server", "app.server.managementApi");
        }
    }

    @Override
    protected final XmlaResponse executeOlapEngineRequest(XmlaQueryContext context, T request, OlapEngineRequestContext requestContext) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("XMLA : executing " + request.getUserFriendlyTypeName() + " " + request.getSchema()));
        }
        return this.doExecuteOlapEngineRequest(context, request, requestContext);
    }

    protected abstract XmlaResponse doExecuteOlapEngineRequest(XmlaQueryContext var1, T var2, OlapEngineRequestContext var3);

    @Override
    protected final XmlaResponse executeOlapEngineRequestForPrepare(XmlaQueryContext context, T request, OlapEngineRequestContext requestContext) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("XMLA : executing " + request.getUserFriendlyTypeName() + " " + request.getSchema()));
        }
        return this.doExecuteOlapEngineRequestForPrepare(context, request, requestContext);
    }

    protected abstract XmlaResponse doExecuteOlapEngineRequestForPrepare(XmlaQueryContext var1, T var2, OlapEngineRequestContext var3);

    public static XmlaMdxResponse createSchemaLifeCycleXmlaResponse(XmlaQueryContext context, XmlaExecuteQuery request, @Nullable OlapSchemaLifeCycleStatus status, @Nullable OlapSchemaInformation loadedSchemaInfo) {
        XmlaFormat format;
        String backupStatus = null;
        String writtenOfflineSnapshot = null;
        if (loadedSchemaInfo != null) {
            writtenOfflineSnapshot = loadedSchemaInfo.getWrittenOfflineSnapshot();
            backupStatus = loadedSchemaInfo.getBackupStatus();
        }
        if ((format = request.getActualFormat()) == XmlaFormat.Tabular) {
            IXmlaRowSet xmlaResult = XmlaManagementApiQueryHandler.createRowSetForSchemaManagement(status, writtenOfflineSnapshot, backupStatus);
            return new XmlaExecuteSchemaLifeCycleRowSetResponse(request.getSessionId(), request, xmlaResult, status);
        }
        if (format == XmlaFormat.Multidimensional) {
            IXmlaMDDataSet xmlaResult = XmlaManagementApiQueryHandler.createMdDataSetForSchemaManagement(status, writtenOfflineSnapshot, backupStatus);
            return new XmlaExecuteSchemaLifeSchemaMDDataSetResponse(request.getSessionId(), request, xmlaResult, status);
        }
        throw new RuntimeException("internal error : unexpected XMLA response format [" + String.valueOf(format) + "]");
    }

    protected static IXmlaRowSet createRowSetForSchemaManagement(@Nullable OlapSchemaLifeCycleStatus status, @Nullable String writtenOfflineSnapshot, @Nullable String backupStatus) {
        if (status == null) {
            return new XmlaSchemaManagementRowSet();
        }
        String result = XmlaManagementApiQueryHandler.setupResult(status, writtenOfflineSnapshot, backupStatus);
        return new XmlaSchemaManagementRowSet(result);
    }

    protected static IXmlaMDDataSet createMdDataSetForSchemaManagement(@Nullable OlapSchemaLifeCycleStatus status, @Nullable String writtenOfflineSnapshot, @Nullable String backupStatus) {
        if (status == null) {
            return new XmlaSchemaManagementMDDataSet();
        }
        String result = XmlaManagementApiQueryHandler.setupResult(status, writtenOfflineSnapshot, backupStatus);
        return new XmlaSchemaManagementMDDataSet(result);
    }

    private static String setupResult(OlapSchemaLifeCycleStatus status, @Nullable String writtenOfflineSnapshot, @Nullable String backupStatus) {
        OlapSchemaLoadStatus loadStatus;
        Object result = writtenOfflineSnapshot != null ? ((loadStatus = status.getLoadStatus()) == OlapSchemaLoadStatus.LOADED ? status.getLoadStatus().name() + ":" + writtenOfflineSnapshot : status.getLoadStatus().name()) : (backupStatus != null ? status.getLoadStatus().name() + ":" + backupStatus : status.getLoadStatus().name());
        return result;
    }
}

