/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.server.iccube.server.message.common;

import crazydev.common.lang.CdXmlaSchemaType;
import crazydev.common.xml.CdXmlUtils;
import crazydev.iccube.cluster.master.backup.info.M_BackupActivityInfo;
import crazydev.iccube.cluster.master.backup.info.M_BackupInfo;
import crazydev.iccube.cluster.shared.backup.S_BackupMode;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapStringEntity;
import crazydev.xmla.model.mddataset.IXmlaPropertyValue;
import crazydev.xmla.model.rowset.IXmlaRowSetDataRow;
import crazydev.xmla.model.rowset.XmlaAbstractRowSet;
import crazydev.xmla.server.iccube.mddataset.XmlaPropertyValue;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class XmlaListSchemaBackupManagementRowSet
extends XmlaAbstractRowSet {
    private final Title title;
    private final List<Info> info = new ArrayList<Info>();

    public XmlaListSchemaBackupManagementRowSet(Iterable<M_BackupInfo> backups) {
        this.title = new Title();
        for (M_BackupInfo backup : backups) {
            List activities = backup.getActivities();
            this.info.add(new Info(this.title, backup, null));
            for (M_BackupActivityInfo activity : activities) {
                this.info.add(new Info(this.title, backup, activity));
            }
        }
    }

    public boolean isBlank() {
        return false;
    }

    public IXmlaRowSetDataRow getTitle() {
        return this.title;
    }

    public Iterable<? extends IXmlaRowSetDataRow> getRows() {
        return this.info;
    }

    static class Title
    implements IXmlaRowSetDataRow {
        private final List<OlapStringEntity> identifiers = new ArrayList<OlapStringEntity>();

        public Title() {
            this.identifiers.add(new OlapStringEntity("schema"));
            this.identifiers.add(new OlapStringEntity("timestamp"));
            this.identifiers.add(new OlapStringEntity("status"));
            this.identifiers.add(new OlapStringEntity("activity-timestamp"));
            this.identifiers.add(new OlapStringEntity("activity-type"));
            this.identifiers.add(new OlapStringEntity("activity-status"));
        }

        public int size() {
            return this.identifiers.size();
        }

        public String getXmlElementName(int col) {
            String name = this.identifiers.get(col).value();
            return CdXmlUtils.escapeForTagName((String)name);
        }

        public IXmlaPropertyValue get(int col) {
            OlapStringEntity name = this.identifiers.get(col);
            return new XmlaPropertyValue(false, CdXmlaSchemaType.DBTYPE_WSTR, name.asXmlaString());
        }
    }

    static class Info
    implements IXmlaRowSetDataRow {
        private final Title title;
        private final List<OlapScalarEntity> entities = new ArrayList<OlapScalarEntity>();

        public Info(Title title, M_BackupInfo backup, @Nullable M_BackupActivityInfo activity) {
            this.title = title;
            this.entities.add((OlapScalarEntity)new OlapStringEntity(backup.getSchema()));
            this.entities.add((OlapScalarEntity)new OlapStringEntity(backup.getTimestamp()));
            this.entities.add((OlapScalarEntity)new OlapStringEntity(backup.getStatus()));
            if (activity != null) {
                this.entities.add((OlapScalarEntity)new OlapStringEntity(activity.getTimestamp()));
                this.entities.add((OlapScalarEntity)new OlapStringEntity(activity.getKind()));
                this.entities.add((OlapScalarEntity)new OlapStringEntity(activity.getStatus()));
            } else {
                this.entities.add((OlapScalarEntity)new OlapStringEntity(backup.getTimestamp()));
                this.entities.add((OlapScalarEntity)new OlapStringEntity(S_BackupMode.FULL_LOAD.name()));
                this.entities.add((OlapScalarEntity)new OlapStringEntity(backup.getStatus()));
            }
        }

        public int size() {
            return this.title.size();
        }

        public String getXmlElementName(int col) {
            return this.title.getXmlElementName(col);
        }

        public IXmlaPropertyValue get(int col) {
            OlapScalarEntity entity = this.entities.get(col);
            return new XmlaPropertyValue(false, CdXmlaSchemaType.DBTYPE_WSTR, entity.asXmlaString());
        }
    }
}

