/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.server.iccube.server.message.common;

import crazydev.iccube.cluster.master.backup.info.M_BackupActivityInfo;
import crazydev.iccube.cluster.master.backup.info.M_BackupInfo;
import crazydev.iccube.cluster.shared.backup.S_BackupMode;
import crazydev.iccube.olap.entity.properties.cell.OlapIntrinsicCellProperties;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapStringEntity;
import crazydev.xmla.model.mddataset.IXmlaAxes;
import crazydev.xmla.model.mddataset.IXmlaAxesInfo;
import crazydev.xmla.model.mddataset.IXmlaAxis;
import crazydev.xmla.model.mddataset.IXmlaAxisInfo;
import crazydev.xmla.model.mddataset.IXmlaCell;
import crazydev.xmla.model.mddataset.IXmlaCellData;
import crazydev.xmla.model.mddataset.IXmlaCellInfo;
import crazydev.xmla.model.mddataset.IXmlaCellProperty;
import crazydev.xmla.model.mddataset.IXmlaCube;
import crazydev.xmla.model.mddataset.IXmlaCubeInfo;
import crazydev.xmla.model.mddataset.IXmlaDimensionProperty;
import crazydev.xmla.model.mddataset.IXmlaError;
import crazydev.xmla.model.mddataset.IXmlaHierarchyInfo;
import crazydev.xmla.model.mddataset.IXmlaMDDataSet;
import crazydev.xmla.model.mddataset.IXmlaMember;
import crazydev.xmla.model.mddataset.IXmlaOlapInfo;
import crazydev.xmla.model.mddataset.IXmlaPropertyValue;
import crazydev.xmla.model.mddataset.IXmlaTuple;
import crazydev.xmla.model.mddataset.IXmlaTuples;
import crazydev.xmla.server.iccube.mddataset.XmlaCellProperty;
import crazydev.xmla.server.iccube.mddataset.XmlaDimensionProperty;
import crazydev.xmla.server.iccube.mddataset.XmlaMemberPropertyValues;
import crazydev.xmla.server.iccube.mddataset.XmlaPropertyValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class XmlaListSchemaBackupManagementMDDataSet
implements IXmlaMDDataSet {
    private final Axes axes;
    private final XmlaCellData cellData;
    private final XmlaOlapInfo olapInfo;

    public XmlaListSchemaBackupManagementMDDataSet(Iterable<M_BackupInfo> backups) {
        this.axes = new Axes(backups);
        int measuresCount = this.axes.getAxes().get(0).getTupleCount();
        this.cellData = new XmlaCellData(measuresCount, this.createCells(backups));
        IXmlaMember member = ((IXmlaTuple)this.axes.getAxes().get(0).getTuples().getTuples().get(0)).getMember(0);
        List properties = member.getProperties();
        this.olapInfo = new XmlaOlapInfo(this.cellData.cellProperties, properties);
    }

    private List<XmlaCell> createCells(Iterable<M_BackupInfo> backups) {
        ArrayList<XmlaCell> cells = new ArrayList<XmlaCell>();
        int ordinal = 0;
        for (M_BackupInfo backup : backups) {
            List activities = backup.getActivities();
            ordinal = this.addCells(cells, ordinal, backup, null);
            for (M_BackupActivityInfo activity : activities) {
                ordinal = this.addCells(cells, ordinal, backup, activity);
            }
        }
        return cells;
    }

    private int addCells(List<XmlaCell> cells, int ordinal, M_BackupInfo backup, @Nullable M_BackupActivityInfo activity) {
        cells.add(new XmlaCell(ordinal++, backup.getSchema()));
        cells.add(new XmlaCell(ordinal++, backup.getTimestamp()));
        cells.add(new XmlaCell(ordinal++, backup.getStatus()));
        if (activity != null) {
            cells.add(new XmlaCell(ordinal++, activity.getTimestamp()));
            cells.add(new XmlaCell(ordinal++, activity.getKind()));
            cells.add(new XmlaCell(ordinal++, activity.getStatus()));
        } else {
            cells.add(new XmlaCell(ordinal++, backup.getTimestamp()));
            cells.add(new XmlaCell(ordinal++, S_BackupMode.FULL_LOAD.name()));
            cells.add(new XmlaCell(ordinal++, backup.getStatus()));
        }
        return ordinal;
    }

    public boolean isBlank() {
        return false;
    }

    public IXmlaOlapInfo getOlapInfo() {
        return this.olapInfo;
    }

    public IXmlaAxes getAxes() {
        return this.axes;
    }

    public IXmlaCellData getCellData() {
        return this.cellData;
    }

    static class Axes
    implements IXmlaAxes {
        final ArrayList<IXmlaAxis> axes = new ArrayList();

        Axes(Iterable<M_BackupInfo> backups) {
            this.axes.add(new Axis("Axis0", this.createTuplesAxis0()));
            this.axes.add(new Axis("Axis1", this.createTuplesAxis1(backups)));
        }

        private XmlaTuples createTuplesAxis0() {
            ArrayList<XmlaTuple> tuples = new ArrayList<XmlaTuple>();
            this.addMeasure(tuples, "schema");
            this.addMeasure(tuples, "timestamp");
            this.addMeasure(tuples, "status");
            this.addMeasure(tuples, "activity-timestamp");
            this.addMeasure(tuples, "activity-type");
            this.addMeasure(tuples, "activity-status");
            return new XmlaTuples(tuples);
        }

        private void addMeasure(List<XmlaTuple> tuples, String name) {
            ArrayList<XmlaMember> members = new ArrayList<XmlaMember>();
            members.add(new XmlaMember("[Measures].[Measures]", "[Measures].[Measures].[Measures]", "[Measures].[" + name + "]", name));
            tuples.add(new XmlaTuple(members));
        }

        private XmlaTuples createTuplesAxis1(Iterable<M_BackupInfo> backups) {
            ArrayList<XmlaTuple> tuples = new ArrayList<XmlaTuple>();
            int ii = 0;
            for (M_BackupInfo backup : backups) {
                List activities = backup.getActivities();
                this.addMember(tuples, ii++);
                for (M_BackupActivityInfo activity : activities) {
                    this.addMember(tuples, ii++);
                }
            }
            return new XmlaTuples(tuples);
        }

        private void addMember(List<XmlaTuple> tuples, int index) {
            ArrayList<XmlaMember> members = new ArrayList<XmlaMember>();
            members.add(new XmlaMember("[Backup].[Backup]", "[Backup].[Backup].[Backup]", "[Backup].[Backup].[" + index + "]", "" + index));
            tuples.add(new XmlaTuple(members));
        }

        public List<IXmlaAxis> getAxes() {
            return this.axes;
        }
    }

    static class XmlaCellData
    implements IXmlaCellData {
        final int measuresCount;
        final List<IXmlaCellProperty> cellProperties = new ArrayList<IXmlaCellProperty>();
        final List<XmlaCell> cells;

        XmlaCellData(int measuresCount, List<XmlaCell> cells) {
            this.measuresCount = measuresCount;
            this.cellProperties.add(new XmlaCellProperty(OlapIntrinsicCellProperties.CELL_ORDINAL));
            this.cellProperties.add(new XmlaCellProperty(OlapIntrinsicCellProperties.VALUE));
            this.cells = cells;
        }

        public int getMaxOrdinal() {
            return this.cells.size() - 1;
        }

        @Nullable
        public IXmlaCell getCellByOrdinal(int ordinal) {
            return this.cells.get(ordinal);
        }

        @Nullable
        public IXmlaCell getCell(int ... Si) {
            if (Si == null) {
                throw new RuntimeException("missing Si");
            }
            if (Si.length != 2) {
                throw new RuntimeException("inconsistent Si length [" + Si.length + "] - expecting 2");
            }
            return this.cells.get(Si[0] * this.measuresCount + Si[1]);
        }
    }

    static class XmlaOlapInfo
    implements IXmlaOlapInfo {
        final XmlaCubeInfo cubeInfo = new XmlaCubeInfo();
        final XmlaAxesInfo axesInfo;
        final List<? extends IXmlaCellProperty> cellProperties;

        XmlaOlapInfo(List<? extends IXmlaCellProperty> cellProperties, List<XmlaDimensionProperty> memberProperties) {
            this.cellProperties = cellProperties;
            this.axesInfo = new XmlaAxesInfo(memberProperties);
        }

        public IXmlaCubeInfo getCubeInfo() {
            return this.cubeInfo;
        }

        public IXmlaAxesInfo getAxesInfo() {
            return this.axesInfo;
        }

        public IXmlaCellInfo getCellInfo() {
            return new IXmlaCellInfo(this){
                final /* synthetic */ XmlaOlapInfo this$0;
                {
                    XmlaOlapInfo xmlaOlapInfo = this$0;
                    Objects.requireNonNull(xmlaOlapInfo);
                    this.this$0 = xmlaOlapInfo;
                }

                public List<? extends IXmlaCellProperty> getCellProperties() {
                    return this.this$0.cellProperties;
                }
            };
        }
    }

    static class XmlaCell
    implements IXmlaCell {
        final int ordinal;
        final String value;

        XmlaCell(int ordinal, String value) {
            this.ordinal = ordinal;
            this.value = value;
        }

        public int getOrdinal() {
            return this.ordinal;
        }

        public int getPropertyCount() {
            return 2;
        }

        public IXmlaPropertyValue getPropertyValue(int propertyIndex) {
            if (propertyIndex == 0) {
                return new XmlaPropertyValue((OlapScalarEntity)new OlapNumericEntity((long)this.getOrdinal()));
            }
            return new XmlaPropertyValue((OlapScalarEntity)new OlapStringEntity(this.value));
        }

        public IXmlaPropertyValue getPropertyValue(String propertyName) {
            if (OlapIntrinsicCellProperties.CELL_ORDINAL.getName().equals(propertyName)) {
                return this.getPropertyValue(0);
            }
            return this.getPropertyValue(1);
        }

        public boolean isOnError() {
            return false;
        }

        public IXmlaError getError() {
            return null;
        }
    }

    static class XmlaHierarchyInfo
    implements IXmlaHierarchyInfo {
        final String uniqueName;
        final List<XmlaDimensionProperty> properties;

        XmlaHierarchyInfo(String uniqueName, List<XmlaDimensionProperty> properties) {
            this.uniqueName = uniqueName;
            this.properties = properties;
        }

        public String getUniqueName() {
            return this.uniqueName;
        }

        public List<? extends IXmlaDimensionProperty> getProperties() {
            return this.properties;
        }
    }

    static class XmlaAxisInfo
    implements IXmlaAxisInfo {
        final String name;
        final List<XmlaHierarchyInfo> infos = new ArrayList<XmlaHierarchyInfo>();

        XmlaAxisInfo(String name, XmlaHierarchyInfo info) {
            this.name = name;
            this.infos.add(info);
        }

        public String getName() {
            return this.name;
        }

        public List<? extends IXmlaHierarchyInfo> getHierarchyInfo() {
            return this.infos;
        }

        public boolean isEmpty() {
            return this.infos.isEmpty();
        }
    }

    static class XmlaAxesInfo
    implements IXmlaAxesInfo {
        final List<XmlaAxisInfo> info = new ArrayList<XmlaAxisInfo>();

        XmlaAxesInfo(List<XmlaDimensionProperty> properties) {
            this.info.add(new XmlaAxisInfo("Axis0", new XmlaHierarchyInfo("[Measures].[Measures]", properties)));
            this.info.add(new XmlaAxisInfo("Axis1", new XmlaHierarchyInfo("[Backup].[Backup]", properties)));
        }

        public boolean isEmpty() {
            return false;
        }

        public List<? extends IXmlaAxisInfo> getAxisInfo() {
            return this.info;
        }
    }

    static class XmlaCubeInfo
    implements IXmlaCubeInfo {
        final IXmlaCube cube = new IXmlaCube(this){
            {
                Objects.requireNonNull(this$0);
            }

            public String getName() {
                return "$Monitoring";
            }

            public Date getLastUpdate() {
                return new Date();
            }
        };

        XmlaCubeInfo() {
        }

        public List<IXmlaCube> getCubes() {
            return Arrays.asList(this.cube);
        }
    }

    static class XmlaMember
    implements IXmlaMember {
        final String memberHierarchyUniqueName;
        final String memberLevelUniqueName;
        final String memberUniqueName;
        final String memberCaption;
        final XmlaMemberPropertyValues propertyValues;

        XmlaMember(String memberHierarchyUniqueName, String memberLevelUniqueName, String memberUniqueName, String memberCaption) {
            this.memberHierarchyUniqueName = memberHierarchyUniqueName;
            this.memberLevelUniqueName = memberLevelUniqueName;
            this.memberUniqueName = memberUniqueName;
            this.memberCaption = memberCaption;
            this.propertyValues = new XmlaMemberPropertyValues(memberHierarchyUniqueName, memberLevelUniqueName, 0, memberUniqueName, memberCaption);
        }

        public String getHierarchyUniqueName() {
            return this.memberHierarchyUniqueName;
        }

        public String getLevelUniqueName() {
            return this.memberLevelUniqueName;
        }

        public int getLevelNumber() {
            return 0;
        }

        public String getUniqueName() {
            return this.memberUniqueName;
        }

        public String getCaption() {
            return this.memberCaption;
        }

        public String getDisplayInfo() {
            return "";
        }

        public List<? extends IXmlaDimensionProperty> getProperties() {
            return this.propertyValues.getProperties();
        }

        public List<? extends IXmlaPropertyValue> getValues() {
            return this.propertyValues.getValues();
        }
    }

    static class XmlaTuple
    implements IXmlaTuple {
        final List<XmlaMember> members;

        XmlaTuple(List<XmlaMember> members) {
            this.members = members;
        }

        public int size() {
            return this.members.size();
        }

        public IXmlaMember getMember(int idx) {
            return this.members.get(idx);
        }

        public List<? extends IXmlaMember> getMembers() {
            return this.members;
        }
    }

    static class XmlaTuples
    implements IXmlaTuples {
        final List<XmlaTuple> tuples;

        XmlaTuples(List<XmlaTuple> tuples) {
            this.tuples = tuples;
        }

        public boolean isEmpty() {
            return this.tuples.isEmpty();
        }

        public int size() {
            return this.tuples.size();
        }

        public List<? extends IXmlaTuple> getTuples() {
            return this.tuples;
        }
    }

    static class Axis
    implements IXmlaAxis {
        final String name;
        final XmlaTuples tuples;

        Axis(String name, XmlaTuples tuples) {
            this.name = name;
            this.tuples = tuples;
        }

        public String getName() {
            return this.name;
        }

        public boolean hasTuples() {
            return this.tuples.size() > 0;
        }

        public int getTupleCount() {
            return this.tuples.size();
        }

        public IXmlaTuples getTuples() {
            return this.tuples;
        }

        public boolean isSlicer() {
            return false;
        }
    }
}

