/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.server.iccube.server.message;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.exception.CdCommonErrorCode;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.exception.CdException;
import crazydev.common.exception.CdRuntimeException;
import crazydev.xmla.model.message.XmlaSerializer;
import crazydev.xmla.server.iccube.server.message.XmlaResponse;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XmlaFault
extends XmlaResponse {
    @Nullable
    private final String sessionId;
    private final CdBabylonService babylon;
    @Nullable
    private final Throwable exception;
    @Nullable
    private final String error;

    public XmlaFault(@Nullable String sessionId, CdBabylonService babylon, Throwable exception) {
        this.sessionId = sessionId;
        this.babylon = babylon;
        this.exception = exception;
        this.error = null;
    }

    public XmlaFault(@Nullable String sessionId, CdBabylonService babylon, String error) {
        this.sessionId = sessionId;
        this.babylon = babylon;
        this.exception = null;
        this.error = error;
    }

    @Override
    @Nullable
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    protected void emitSoapEnvelopeHeader(XmlaSerializer serializer) throws SAXException {
    }

    @Override
    protected void doEmitSoapEnvelopeBody(XmlaSerializer serializer) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute(null, null, "xmlns", "string", "http://schemas.xmlsoap.org/soap/envelope/");
        serializer.startElement(null, null, "soap:Fault", (Attributes)attrs);
        this.doEmitFaultCode(serializer);
        this.doEmitFaultString(serializer);
        this.doEmitDetail(serializer);
        serializer.endElement(null, null, "soap:Fault");
    }

    private void doEmitFaultCode(XmlaSerializer serializer) throws SAXException {
        CdErrorCode code = this.getErrorCode();
        String hex = Long.toHexString(code.getNumericalValue());
        serializer.addElement("faultcode", "XMLAnalysisError.0x" + hex);
    }

    private void doEmitFaultString(XmlaSerializer serializer) throws SAXException {
        String message = this.getErrorMessage();
        serializer.addElement("faultstring", message == null ? "not-available" : message);
    }

    private void doEmitDetail(XmlaSerializer serializer) throws SAXException {
        serializer.startElement(null, null, "detail", null);
        AttributesImpl errorAttrs = new AttributesImpl();
        CdErrorCode errorCode = this.getErrorCode();
        String code = "" + errorCode.getNumericalValue();
        errorAttrs.addAttribute(null, null, "ErrorCode", "string", code);
        errorAttrs.addAttribute(null, null, "Description", "string", this.getErrorMessage());
        serializer.startElement(null, null, "Error", (Attributes)errorAttrs);
        serializer.endElement(null, null, "Error");
        serializer.endElement(null, null, "detail");
    }

    public CdErrorCode getErrorCode() {
        if (this.exception instanceof CdException) {
            return ((CdException)this.exception).getErrorCode();
        }
        if (this.exception instanceof CdRuntimeException) {
            return ((CdRuntimeException)this.exception).getErrorCode();
        }
        return CdCommonErrorCode.GENERAL_ERROR;
    }

    public String getErrorMessage() {
        if (this.exception instanceof CdException) {
            return ((CdException)this.exception).getError().asMessage(this.babylon);
        }
        if (this.exception instanceof CdRuntimeException) {
            return ((CdRuntimeException)this.exception).getError().asMessage(this.babylon);
        }
        if (this.exception != null) {
            return this.exception.getMessage();
        }
        return this.error;
    }
}

