/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.server.iccube.rowset;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.xml.CdXmlUtils;
import crazydev.iccube.olap.entity.result.OlapResDrillthroughStatementDataSet;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapStringEntity;
import crazydev.iccube.olap.goodies.drillthrough.OlapDrillthroughCollection;
import crazydev.iccube.olap.goodies.drillthrough.OlapDrillthroughCollectionHeader;
import crazydev.iccube.olap.goodies.drillthrough.OlapDrillthroughCollectionRow;
import crazydev.xmla.model.mddataset.IXmlaPropertyValue;
import crazydev.xmla.model.rowset.IXmlaRowSetDataRow;
import crazydev.xmla.model.rowset.XmlaAbstractRowSet;
import crazydev.xmla.server.iccube.mddataset.XmlaPropertyValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class XmlaDrillthroughRowSet
extends XmlaAbstractRowSet {
    private final Title title;
    private final Rows rows;

    public XmlaDrillthroughRowSet(OlapResDrillthroughStatementDataSet result) {
        OlapDrillthroughCollection collection = result.getCollection();
        this.title = new Title(collection.getHeader());
        this.rows = new Rows(this.title, collection.getRows());
    }

    public boolean isBlank() {
        return false;
    }

    public IXmlaRowSetDataRow getTitle() {
        return this.title;
    }

    public Iterable<Rows.Row> getRows() {
        return this.rows.rows;
    }

    static class Title
    implements IXmlaRowSetDataRow {
        private final List<OlapStringEntity> identifiers = new ArrayList<OlapStringEntity>();

        public Title(OlapDrillthroughCollectionHeader header) {
            for (String columnId : header.getIdentifiers()) {
                this.identifiers.add(new OlapStringEntity(columnId));
            }
        }

        public int size() {
            return this.identifiers.size();
        }

        public String getXmlElementName(int col) {
            String name = this.identifiers.get(col).value();
            return CdXmlUtils.escapeForTagName((String)name);
        }

        public IXmlaPropertyValue get(int col) {
            OlapStringEntity name = this.identifiers.get(col);
            return new XmlaPropertyValue((OlapScalarEntity)name);
        }
    }

    static class Rows {
        private final Title title;
        private final List<Row> rows = new ArrayList<Row>();

        public Rows(Title title, Iterable<OlapDrillthroughCollectionRow> rows) {
            this.title = title;
            for (OlapDrillthroughCollectionRow row : rows) {
                this.rows.add(new Row(this, row));
                if (row.size() == title.size()) continue;
                throw new CdProgrammingException("internal error: inconsistent row size!");
            }
        }

        class Row
        implements IXmlaRowSetDataRow {
            private final List<OlapScalarEntity> entities;
            final /* synthetic */ Rows this$0;

            public Row(Rows this$0, OlapDrillthroughCollectionRow row) {
                Rows rows = this$0;
                Objects.requireNonNull(rows);
                this.this$0 = rows;
                this.entities = new ArrayList<OlapScalarEntity>();
                for (OlapScalarEntity entity : row.getEntities()) {
                    this.entities.add(entity.asConstant());
                }
            }

            public int size() {
                return this.this$0.title.size();
            }

            public String getXmlElementName(int col) {
                return this.this$0.title.getXmlElementName(col);
            }

            public IXmlaPropertyValue get(int col) {
                OlapScalarEntity entity = this.entities.get(col);
                return new XmlaPropertyValue(entity);
            }
        }
    }
}

